package gov.va.med.hac.edi.ewv2.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

import javax.faces.model.SelectItem;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

@Name("Ewv2RecentPdiNumbers")
@Scope(ScopeType.SESSION)
public class MostRecentPdiNumbers implements Serializable
{
    private boolean       changed  = false;
    
    private Stack<String> pdiStack = new Stack<String>();
    
    public void addPdi(String pdi)
    {
        if (pdiStack.size() >= 5) {
            pdiStack.remove(0);
        }
        
        if (!this.pdiStack.contains(pdi)) {
            pdiStack.push(pdi);
            
            changed = true;
        }
        else {
            changed = false;
        }
    }
    
    public List<SelectItem> getRecentPdiNumbers()
    {
        List<SelectItem> list = new ArrayList<SelectItem>();
        
        for (String str : pdiStack) {
            list.add(new SelectItem(str));
        }
        
        Collections.reverse(list);
        
        return list;
    }
    
    public List<String> getRecentStringPdiNumbers()
    {
        List<String> list = new ArrayList<String>();
        
        for (String str : this.pdiStack) {
            list.add(str);
        }
        
        Collections.reverse(list);
        
        return list;
    }
    
    public boolean hasChanged()
    {
        return this.changed;
    }
}
