package gov.va.med.hac.edi.ewv2.utils;

import java.util.Locale;
import java.util.ResourceBundle;

public class BundleReader
{
    private static BundleReader instance = new BundleReader();
    private static ResourceBundle theBundle = null;
    
    private String bundleName = "messages";
    
    private BundleReader()
    {
        config(bundleName);
    }
    
    private static void config(String bundleName)
    {
        theBundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());  
    }

    public static BundleReader getInstance(String bundleName) 
    {
        if(bundleName != null && !bundleName.equals("messages"))
        {
            config(bundleName);    
        }
        
        return instance;
    }
    
    public String getProperty(String key)
    {
        return theBundle.getString(key);
    }
}
 