/*
 * $Id: IDCheckServlet.java,v 1.2 2011/03/25 22:55:58 vhahacbergri Exp $
 */
package gov.va.med.hac.edi.ewv2.security;

import java.io.IOException;
import java.net.URLDecoder;

import javax.servlet.ServletException;
import javax.servlet.http.*;

/**
 * The Class IDCheckServlet.
 * 
 * @author vhahacnguyes, vhahacbergri
 */
public class IDCheckServlet extends HttpServlet
{
    
    /*
     * (non-Javadoc)
     * 
     * @see javax.servlet.GenericServlet#init()
     */
    @Override
    public void init() throws ServletException
    {
        System.out.println("IDCheckServlet init.");
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see
     * javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest
     * , javax.servlet.http.HttpServletResponse)
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        logDebug("In doGet, going to doPost");
        doPost(req, resp);
        
    }
    
    /**
     * Is the given string null, or blank after trimming?
     * 
     * @param value
     *            the value
     * 
     * @return true, if is valid
     */
    private boolean isValid(String value)
    {
        logDebug("Checking validity of: " + value);
        return value != null && value.trim().length() > 0 ? true : false;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see
     * javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest
     * , javax.servlet.http.HttpServletResponse)
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        String userId = "";
        String capturedUrl = "";
		try {
			String paramI = URLDecoder.decode(req.getParameter("i"),"UTF-8");
			String paramC = URLDecoder.decode(req.getParameter("c"),"UTF-8");
			logDebug("In servlet doPost, parameter [i]: " + paramI);
			logDebug("In servlet doPost, parameter [c]: " + paramC);
			userId = IDCheckAESEncryption.decrypt(paramI);
			logDebug("In servlet doPost, userId: " + userId);
			capturedUrl = IDCheckAESEncryption.decrypt(paramC);
			logDebug("capturedUrl: " + capturedUrl);
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}        
        String sessionId = req.getParameter("s");
        logDebug("sessionId in parameter: " + sessionId);        
        
        HttpSession session = req.getSession();
        String sId = session.getId() + session.hashCode();
        logDebug("Id in session: " + sId);
        
        String existingUser = (String) session.getAttribute(IDCheckFilter.SEC_USER);
        logDebug("In doPost, session user: " + existingUser);
        
        // if any parameters are wrong or user Id already set
        // (bean may be instantiated by the JSF engine when the error page is
        // rendered.) This will ensure only one post back per session.
        boolean status = true;
        status &= isValid(userId);
        status &= isValid(sessionId);
        status &= isValid(capturedUrl);
        
        // Under certain circumstances, the session id reported by the ASP page
        // is not the same as the one found by the servlet. Possibly, this
        // is due to the use of a different URL, ie. with and without the
        // vha.domain.ext part. Anyway, we removed this check because of
        // that situation.
        // status &= sId.equals(sessionId);
        
        if (isValid(existingUser))
        {
            status &= userId.equals(existingUser);
        }
        logDebug("In doPost, status result is: " + status);
        if (!status)
        {
            try
            {
                logDebug("Invalidating the session");
                session.removeAttribute(IDCheckFilter.SEC_USER);
                session.invalidate();
            }
            catch (IllegalStateException e)
            {
                // Ignore! For IE, when user clicks back button twice after
                // login this is called twice.
            }
            System.err.println(new StringBuffer("Error authorizing [").append(" Rec - userId:" + userId).append(
                    " sessionId:" + sessionId).append(" capturedUrl:" + capturedUrl).append(
                    " App - existingUser:" + existingUser).append(" sId:" + sId).append("]").toString());
            String errorPage = (String) req.getAttribute(IDCheckFilter.ERROR_PAGE);
            
            // If we didn't get the information we need, go to the error page
            resp.sendRedirect(errorPage);
            return;
        }
        
        existingUser = new String(userId);
        
        // Put this user into the HTTP session. This is the point of this servlet
        session.setAttribute(IDCheckFilter.SEC_USER, existingUser);
        //System.out.println("IDCheckServlet set SEC_USER: "+existingUser);
            
        getServletContext().setAttribute("user", existingUser);

        // Redirect to the url that was originally requested by the user.
        logDebug("Redirecting to: " + capturedUrl);
        resp.sendRedirect(capturedUrl);
    }
    
    private void logDebug(String s)
    {
         System.out.println("IDCheckServlet:" + s);
    }
    
}
