package gov.va.med.hac.edi.ewv2.security;

import java.io.*;
import java.sql.*;

import javax.naming.*;
import javax.sql.DataSource;
import java.util.*;

import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.*;
import org.jboss.seam.log.Log;
import org.jboss.seam.annotations.Name;

/**
 * EdiWebViewerAuthorizer collects utility methods used to authorize users of
 * the Tracker web application against the SQL Server database, using multiple
 * applications in that database and multiple roles in each application.
 * 
 * @author vhahacbergri
 * 
 */
@Name("Ewv2EdiWebViewerAuthorizer")
@Scope(ScopeType.SESSION)
public class EdiWebViewerAuthorizer implements Serializable {

	@Logger
	Log log;
	private Connection con = null;

	// include this datasource in the hosting app server
	private final String dsJNDI = "java:/WEBAPPDS";
	private ArrayList<Integer> roles = new ArrayList<Integer>();

	public boolean init() {
		boolean ok = false;

		try {
			InitialContext ic = new InitialContext();
			DataSource ds = (DataSource) ic.lookup(dsJNDI);
			con = ds.getConnection();
			log.debug("Connected to SQL Server for app-level authentication");

			ok = true;
		} catch (Exception e) {
			log.error("While connecting to SQL Server...", e);
		}

		return ok;
	}

	public List<Integer> getWebAppRoles(String inUsername, Integer inAppId)
			throws NamingException, SQLException {
		// Use a stored procedure to authenticate user against
		// a table, WEBAPP_MASTER_USER, in a SQL Server database
		String queryStr = "EXEC dbo.validateUser @AppID=" + inAppId
				+ ", @NTUsername='" + inUsername + "'";

		// Execute the above query, which represents a stored procedure that
		// takes an application id and a username, and returns a list of role id's
		Statement stmt = con.createStatement();
		ResultSet rs = stmt.executeQuery(queryStr);

		// Put the results of the query one by one into a list
		while (rs.next()) {
			Integer thisRole = rs.getInt("RoleID");
			roles.add(thisRole);
		}

		return roles;
	}

	public Integer getIdFromDatabase(java.util.Properties inProps,
			String inPropertyName) {
		Integer returnId;

		// Get the property as a string
		String idString = (String) inProps.get(inPropertyName);

		// Parse the property as an ing
		if (idString != null && !idString.isEmpty()) {
			returnId = Integer.parseInt(idString);
		} else {
			log.debug(inPropertyName + " not found in properties");
			return null;
		}

		// Return the property as an Integer
		return returnId;
	}

	public List<String> getRoles(String inUsername) throws IOException,
			NamingException, SQLException {
		log.info("In getRoles with: " + inUsername);
		List<String> returnRoles = new ArrayList<String>();

		// Get the mappings between applications (or roles) and db ids
		java.util.Properties props = getProperties("EWV2Application.properties");
		log.info("Got props: " + props);
		if (props == null || props.isEmpty()) {
			return returnRoles;
		}

		// Get the ids out of the properties
		Integer ewvAppId = getIdFromDatabase(props, "EdiWebViewerApplication");
		if (ewvAppId == null) {
			log.debug("Id not found in properties");
			return returnRoles;
		}
		log.info("Got ewvAppId: " + ewvAppId);

		Integer ewvUserId = getIdFromDatabase(props, "ewvUser");
		log.info("Got ewvUserId: " + ewvUserId);

		try {
			// Establish a connection
			if (init()) {
				// What roles does this user have?
				// We had to use multiple applications, because one of their users can only
				// be assigned a single role
				log.debug("Setting roles");
				List<Integer> ewvRoles = getWebAppRoles(inUsername, ewvAppId);
				log.debug("Got ewvRoles: " + ewvRoles);

				// Translate these lists into our web app roles
				if (ewvRoles != null) {
					if (ewvRoles.contains((Integer) ewvUserId)) {
						log.debug("Found ewvUserId");
						returnRoles.add("ewvUser");
						} else {
						log.debug("Did not find ewvUserId");
					}
				}
			} else {
				log.error("database not available");
			}
		} finally {
			// Close the connection that was just opened

			this.close();
		}
		log.debug("Returning returnRoles: " + returnRoles);
		return returnRoles;
	}

	private void close() {
		log.debug("Closing the connection to the app security database");

		try {
			con.close();
		} catch (SQLException e) {
			log.error("while closing connection...", e);
		}
	}

	// Put the list of roles together into a string for the GUI
	final public String concatenateRoles(final List<String> inRoles) {
		String returnString = new String();

		// ediUser
		if (inRoles.contains("ediUser")) {
			returnString += "ediUser";
		}

		return returnString;
	}

	final public java.util.Properties getProperties(final String pFileName)
			throws IOException {
		// If the incoming parameter is null, throw an IOException rather than
		// waiting for a NullPointerException later
		if (pFileName == null) {
			throw new IOException("Properties file name may not be null");
		}

		// Put an input stream onto the specified properties file
		InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(pFileName);

		// Load the file into a properties object for return
		final java.util.Properties props = new java.util.Properties();
		if (inputStream != null) {
			props.load(inputStream);
		}

		return props;
	}

}
