package gov.va.med.hac.edi.ewv2.security;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.naming.NamingException;
import javax.persistence.*;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.*;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.faces.Redirect;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.NotLoggedInException;

@Name("Ewv2Authenticator")
@Scope(ScopeType.SESSION)
public class Authenticator
{
    
    @Logger
    Log                    log;
    
    @In
    protected EntityManager  entityManager;
    
    @In
    Identity               identity;
    
    @In
    Credentials               credentials;
    
    @Out(required = false)
    String                 ntUsername;
    
    @Out(required = false)
    String                 roleList;
    
    @In
    protected Context        sessionContext;
    
    @In(create = true, value="Ewv2EdiWebViewerAuthorizer")
    EdiWebViewerAuthorizer ediWebViewerAuthorizer;
    
    @In(create = true)
    protected FacesMessages  facesMessages;

    // autoAuthenticate is listed in components.xml as the "authenticate-method",
    // but also the method to be run when the notLoggedIn event occurs.
    public boolean autoAuthenticate() throws IOException, NamingException, SQLException
    {
        // If login has already taken place, return.
        if (credentials.getPassword() != null && credentials.getPassword().equals("authenticated")) {
            return true;
        }
        else {
            //log.info("Not short-circuiting, getting roles ");
        }
            // Who is logged into Windows?
            ntUsername = getNTUsername();
            //ntUsername = "NotAllowed";
            //ntUsername = null;
            //log.info("NT username of current user is: " + ntUsername);
            if (ntUsername == null) {
                throw new IOException("Could not retrieve NT username");
            }
        
        // What roles does this user have, according to the SQL Server database?
        List<String> roles = new ArrayList(0); 
          
        //log.info("getting Roles...");
        roles = ediWebViewerAuthorizer.getRoles(ntUsername);
        
        // If they have any role at all, authenticate them
        if (roles != null && !roles.isEmpty())
        {
            //log.info("providing identity...");
            provideIdentity(ntUsername, roles);
            FacesContext.getCurrentInstance().addMessage(
                    "ewvApplication",
                    new FacesMessage(FacesMessage.SEVERITY_ERROR,"New Session", ""));
        }
        // If they have no roles at all, they cannot go anywhere in this app
        else
        {
          log.debug ("No roles, returning false from autoAuthenticate");
          return false;
//            //log.info("user: " + ntUsername+" has no role to execute");
//            
//            this.ssoRedirect();
//            
//            return false;
        }
        
        // Calculate the list of roles to display in the menu bar
        roleList = ediWebViewerAuthorizer.concatenateRoles(roles);
        
        return true;
    }
    
    public void provideIdentity(String inUsername, List<String> inRoles)
    {
        // Set the Seam identity
    	credentials.setUsername(inUsername.toLowerCase());
        credentials.setPassword("meaningless");
        
        // Set their roles
        for (int i = 0; i < inRoles.size(); i++)
        {
            identity.addRole(inRoles.get(i));
        }
        
        // Set the Oracle identity
        //String queryString = "CALL DBMS_SESSION.SET_IDENTIFIER" + "('" + inUsername.toLowerCase() + "')";
        //Boolean success = executeSproc(entityManager, queryString);
        
        //log.info("Provided identity for: " + identity.getUsername());
    }
    
    public void logIdentity()
    {
        log.info("Identity username: " + credentials.getUsername());
        //log.info("Identity password: " + identity.getPassword());
//        log.info("Does user have role erfUser? " + identity.hasRole("erfUser"));
//        log.info("Does user have role erfAdmin? " + identity.hasRole("erfAdmin"));
    }
    
    // This is necessary to overcome the problem that the user is taken to the
    // login screen that is specified in configuration even if they are logged in
    public void ssoRedirect()
    {
        if (identity.isLoggedIn() == true)
        {
            FacesMessages.instance().clear(); // clear the regular Seam messages
            FacesMessages.instance().add("SSO login successful for user #{identity.username}");
            log.debug("User is logged in - redirecting to captured view");
            Redirect.instance().returnToCapturedView(); // return to the
                                                        // originally-requested
                                                        // page
        }
        else
        {
          Redirect.instance().setViewId("/noAccess.xhtml");
          log.info("User is not logged in - redirecting to noAccess");
          Redirect.instance().execute();
        }
    }
    
    // Return the username under which the current user is logged on to Windows
    public String getNTUsername()
    {
        // The sessionContext should have a value under gov.va.med.hac.sec.User,
        // put there by the IDCheckFilter
        Object usernameString = sessionContext.get(IDCheckFilter.SEC_USER);
        
        return ((usernameString == null) ? "" : usernameString.toString());
    }
    
}
