package gov.va.med.hac.edi.ewv2.persistence.base;

public enum ClaimType
{
    DENTAL("004010X097A1","D"), INSTITUTIONAL("004010X096A1","I"), PROFESSIONAL("004010X098A1","P"), NONE(null,null);
    
    String valueOf = null;
    String altValue = null;
    
    ClaimType(String code, String alt)
    {
        valueOf = code;
        altValue = alt;
    }
    
    public String getValueOf()
    {
        return valueOf;
    }
    
    public String getAltValue()
    {
        return altValue;
    }
    
    public static ClaimType typeOf(String value)
    {
        ClaimType val = null;
        
        if (value.equals("004010X097A1") || value.substring(0,10).equals("005010X224"))
        {
            val = ClaimType.DENTAL;
        }
        else if (value.equals("004010X096A1") || value.substring(0,10).equals("005010X223"))
        {
            val = ClaimType.INSTITUTIONAL;
        }
        else if (value.equals("004010X098A1") || value.substring(0,10).equals("005010X222"))
        {
            val = ClaimType.PROFESSIONAL;
        }
        
        return val;
    }
}
