package gov.va.med.hac.edi.ewv2.persistence;


import java.io.Serializable;
import javax.persistence.*;


/**
 * The persistent class for the EWV_SVC_LINE_TEETH database table.
 * 
 */
@Entity
@Table(name="EWV_SVC_LINE_TEETH")
public class EwvSvcLineTeeth implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name="SURFACE1")
	private String surface1;

	@Column(name="SURFACE2")
	private String surface2;

	@Column(name="SURFACE3")
	private String surface3;

	@Column(name="SURFACE4")
	private String surface4;

	@Column(name="SURFACE5")
	private String surface5;

	@Column(name="TOOTH_NUMBER")
	private String toothNumber;

	//bi-directional many-to-one association to EwvServiceLine
    @ManyToOne
	@JoinColumn(name="SVC_LINE_GUID")
	private EwvServiceLine ewvServiceLine;

    public EwvSvcLineTeeth() {
    }

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getSurface1() {
		return this.surface1;
	}

	public void setSurface1(String surface1) {
		this.surface1 = surface1;
	}

	public String getSurface2() {
		return this.surface2;
	}

	public void setSurface2(String surface2) {
		this.surface2 = surface2;
	}

	public String getSurface3() {
		return this.surface3;
	}

	public void setSurface3(String surface3) {
		this.surface3 = surface3;
	}

	public String getSurface4() {
		return this.surface4;
	}

	public void setSurface4(String surface4) {
		this.surface4 = surface4;
	}

	public String getSurface5() {
		return this.surface5;
	}

	public void setSurface5(String surface5) {
		this.surface5 = surface5;
	}

	public String getToothNumber() {
		return this.toothNumber;
	}

	public void setToothNumber(String toothNumber) {
		this.toothNumber = toothNumber;
	}

	public EwvServiceLine getEwvServiceLine() {
		return this.ewvServiceLine;
	}

	public void setEwvServiceLine(EwvServiceLine ewvServiceLine) {
		this.ewvServiceLine = ewvServiceLine;
	}
	
}