package gov.va.med.hac.edi.ewv2.persistence;


import java.io.Serializable;
import javax.persistence.*;


/**
 * The persistent class for the EWV_SVC_LINE_DME database table.
 * 
 */
@Entity
@Table(name="EWV_SVC_LINE_DME")
public class EwvSvcLineDme implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name="DME_FREQUENCY")
	private String dmeFrequency;

	@Column(name="DME_LENGTH_MEDICAL_NECESSITY")
	private String dmeLengthMedicalNecessity;

	@Column(name="DME_PURCHASE_AMT")
	private String dmePurchaseAmt;

	@Column(name="DME_RENTAL_AMT")
	private String dmeRentalAmt;

	//bi-directional many-to-one association to EwvServiceLine
    @ManyToOne
	@JoinColumn(name="SVC_LINE_GUID")
	private EwvServiceLine ewvServiceLine;

    public EwvSvcLineDme() {
    }

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getDmeFrequency() {
		return this.dmeFrequency;
	}

	public void setDmeFrequency(String dmeFrequency) {
		this.dmeFrequency = dmeFrequency;
	}

	public String getDmeLengthMedicalNecessity() {
		return this.dmeLengthMedicalNecessity;
	}

	public void setDmeLengthMedicalNecessity(String dmeLengthMedicalNecessity) {
		this.dmeLengthMedicalNecessity = dmeLengthMedicalNecessity;
	}

	public String getDmePurchaseAmt() {
		return this.dmePurchaseAmt;
	}

	public void setDmePurchaseAmt(String dmePurchaseAmt) {
		this.dmePurchaseAmt = dmePurchaseAmt;
	}

	public String getDmeRentalAmt() {
		return this.dmeRentalAmt;
	}

	public void setDmeRentalAmt(String dmeRentalAmt) {
		this.dmeRentalAmt = dmeRentalAmt;
	}

	public EwvServiceLine getEwvServiceLine() {
		return this.ewvServiceLine;
	}

	public void setEwvServiceLine(EwvServiceLine ewvServiceLine) {
		this.ewvServiceLine = ewvServiceLine;
	}
	
}