package gov.va.med.hac.edi.ewv2.persistence;

import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the EWV_SL_PROVIDER database table.
 * 
 */
@Entity
@Table(name = "EWV_SL_PROVIDER")
public class EwvSlProvider implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name = "PROVIDER_FNAME")
	private String providerFname;

	@Column(name = "PROVIDER_ID")
	private String providerId;

	@Column(name = "PROVIDER_LNAME")
	private String providerLname;

	@Column(name = "PROVIDER_TYPE")
	private String providerType;

	@Column(name = "PROVIDER_NPI_5010")
	private String providerNpi_5010;

	@Column(name = "POSTAL_CODE_5010")
	private String postalCode_5010;

	@Column(name = "PROVIDER_MNAME")
	private String providerMname;

	@Column(name = "TAXONOMY_CODE")
	private String taxonomyCode;

	// bi-directional many-to-one association to EwvServiceLine
	@ManyToOne
	@JoinColumn(name = "SVC_LINE_GUID")
	private EwvServiceLine ewvServiceLine;

	public EwvSlProvider() {
	}

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getProviderFname() {
		return this.providerFname;
	}

	public void setProviderFname(String providerFname) {
		this.providerFname = providerFname;
	}

	public String getProviderId() {
		return this.providerId;
	}

	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}

	public String getProviderLname() {
		return this.providerLname;
	}

	public void setProviderLname(String providerLname) {
		this.providerLname = providerLname;
	}

	public String getProviderType() {
		return this.providerType;
	}

	public void setProviderType(String providerType) {
		this.providerType = providerType;
	}

	public String getProviderNpi_5010() {
		return providerNpi_5010;
	}

	public void setProviderNpi_5010(String providerNpi_5010) {
		this.providerNpi_5010 = providerNpi_5010;
	}

	public String getPostalCode_5010() {
		return postalCode_5010;
	}

	public void setPostalCode_5010(String postalCode_5010) {
		this.postalCode_5010 = postalCode_5010;
	}

	public String getProviderMname() {
		return providerMname;
	}

	public void setProviderMname(String providerMname) {
		this.providerMname = providerMname;
	}

	public String getTaxonomyCode() {
		return taxonomyCode;
	}

	public void setTaxonomyCode(String taxonomyCode) {
		this.taxonomyCode = taxonomyCode;
	}

	public EwvServiceLine getEwvServiceLine() {
		return this.ewvServiceLine;
	}

	public void setEwvServiceLine(EwvServiceLine ewvServiceLine) {
		this.ewvServiceLine = ewvServiceLine;
	}

}