package gov.va.med.hac.edi.ewv2.persistence;


import java.io.Serializable;
import javax.persistence.*;


/**
 * The persistent class for the EWV_SERVICE_LINES_DRUGS database table.
 * 
 */
@Entity
@Table(name="EWV_SERVICE_LINES_DRUGS")
public class EwvServiceLinesDrug implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name="DRUG_RX")
	private String drugRx;

	@Column(name="DRUG_RX_CHARGE")
	private String drugRxCharge;

	@Column(name="DRUG_RX_NDC_CODE")
	private String drugRxNdcCode;

	@Column(name="DRUG_RX_QUANTITY")
	private String drugRxQuantity;

	@Column(name="DRUG_RX_TYPE")
	private String drugRxType;

    @Column(name="DRUG_RX_CATEGORY_5010")
    private String drugRxCategory_5010;

	//bi-directional many-to-one association to EwvServiceLine
    @ManyToOne
	@JoinColumn(name="SERVICE_LINE_GUID")
	private EwvServiceLine ewvServiceLine;

    public EwvServiceLinesDrug() {
    }

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getDrugRx() {
		return this.drugRx;
	}

	public void setDrugRx(String drugRx) {
		this.drugRx = drugRx;
	}

	public String getDrugRxCharge() {
		return this.drugRxCharge;
	}

	public void setDrugRxCharge(String drugRxCharge) {
		this.drugRxCharge = drugRxCharge;
	}

	public String getDrugRxNdcCode() {
		return this.drugRxNdcCode;
	}

	public void setDrugRxNdcCode(String drugRxNdcCode) {
		this.drugRxNdcCode = drugRxNdcCode;
	}

	public String getDrugRxQuantity() {
		return this.drugRxQuantity;
	}

	public void setDrugRxQuantity(String drugRxQuantity) {
		this.drugRxQuantity = drugRxQuantity;
	}

	public String getDrugRxType() {
		return this.drugRxType;
	}

	public void setDrugRxType(String drugRxType) {
		this.drugRxType = drugRxType;
	}

	public String getDrugRxCategory_5010() {
    return drugRxCategory_5010;
  }

  public void setDrugRxCategory_5010(String drugRxCategory_5010) {
    this.drugRxCategory_5010 = drugRxCategory_5010;
  }

  public EwvServiceLine getEwvServiceLine() {
		return this.ewvServiceLine;
	}

	public void setEwvServiceLine(EwvServiceLine ewvServiceLine) {
		this.ewvServiceLine = ewvServiceLine;
	}
	
}