package gov.va.med.hac.edi.ewv2.persistence;


import java.io.Serializable;
import javax.persistence.*;


/**
 * The persistent class for the EWV_SERVICE_LINE_OHI_ADJTMTS database table.
 * 
 */
@Entity
@Table(name="EWV_SERVICE_LINE_OHI_ADJTMTS")
public class EwvServiceLineOhiAdjtmt implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name="CO_AMT")
	private String coAmt;
	
	@Transient
	private String crAmt;

	@Column(name="DESCRIPTION")
	private String description;

	@Column(name="OA_AMT")
	private String oaAmt;

	@Column(name="PI_AMT")
	private String piAmt;

	@Column(name="PR_AMT")
	private String prAmt;

	@Column(name="PRIMARY_PAYER_ID")
	private String primaryPayerId;

	@Column(name="QUANTITY")
	private String quantity;

	@Column(name="SVC_LINE_ADJUSTMT_REASON_CODE")
	private String svcLineAdjustmtReasonCode;

	//bi-directional many-to-one association to EwvServiceLineOhi
    @ManyToOne
	@JoinColumn(name="SVC_LINE_OHI_GUID")
	private EwvServiceLineOhi ewvServiceLineOhi;

    public EwvServiceLineOhiAdjtmt() {
    }

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getCoAmt() {
		return this.coAmt;
	}

	public void setCoAmt(String coAmt) {
		this.coAmt = coAmt;
	}
	
	public String getCrAmt() {
		return this.crAmt;
	}

	public void setCrAmt(String crAmt) {
		this.crAmt = crAmt;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getOaAmt() {
		return this.oaAmt;
	}

	public void setOaAmt(String oaAmt) {
		this.oaAmt = oaAmt;
	}

	public String getPiAmt() {
		return this.piAmt;
	}

	public void setPiAmt(String piAmt) {
		this.piAmt = piAmt;
	}

	public String getPrAmt() {
		return this.prAmt;
	}

	public void setPrAmt(String prAmt) {
		this.prAmt = prAmt;
	}

	public String getPrimaryPayerId() {
		return this.primaryPayerId;
	}

	public void setPrimaryPayerId(String primaryPayerId) {
		this.primaryPayerId = primaryPayerId;
	}

	public String getQuantity() {
		return this.quantity;
	}

	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	public String getSvcLineAdjustmtReasonCode() {
		return this.svcLineAdjustmtReasonCode;
	}

	public void setSvcLineAdjustmtReasonCode(String svcLineAdjustmtReasonCode) {
		this.svcLineAdjustmtReasonCode = svcLineAdjustmtReasonCode;
	}

	public EwvServiceLineOhi getEwvServiceLineOhi() {
		return this.ewvServiceLineOhi;
	}

	public void setEwvServiceLineOhi(EwvServiceLineOhi ewvServiceLineOhi) {
		this.ewvServiceLineOhi = ewvServiceLineOhi;
	}
	
}