package gov.va.med.hac.edi.ewv2.persistence;


import java.io.Serializable;
import javax.persistence.*;

import java.util.Set;


/**
 * The persistent class for the EWV_SERVICE_LINE_OHIS database table.
 * 
 */
@Entity
@Table(name="EWV_SERVICE_LINE_OHIS")
public class EwvServiceLineOhi implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name="ADJUDICATED")
	private String adjudicated;

	@Column(name="BUNDLED_UNBUNDLED_LINE_NUMBER")
	private String bundledUnbundledLineNumber;

	@Column(name="MODIFIER1")
	private String modifier1;

	@Column(name="MODIFIER2")
	private String modifier2;

	@Column(name="MODIFIER3")
	private String modifier3;

	@Column(name="MODIFIER4")
	private String modifier4;

	@Column(name="OHI_ADJUDICATED_DATE")
	private String ohiAdjudicatedDate;

	@Column(name="OHI_PAID")
	private String ohiPaid;

	@Column(name="PROCEDURE_CODE")
	private String procedureCode;

	@Column(name="QUANTITY")
	private String quantity;

	@Column(name="REVENUE_CODE")
	private String revenueCode;

    @Column(name="PAYER_ID")
    private String payerId;

	//bi-directional many-to-one association to EwvServiceLine
    @ManyToOne
	@JoinColumn(name="SVC_LINE_GUID")
	private EwvServiceLine ewvServiceLine;

	//bi-directional many-to-one association to EwvServiceLineOhiAdjtmt
	@OneToMany(mappedBy="ewvServiceLineOhi")
	private Set<EwvServiceLineOhiAdjtmt> ewvServiceLineOhiAdjtmts;

    public EwvServiceLineOhi() {
    }

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getAdjudicated() {
		return this.adjudicated;
	}

	public void setAdjudicated(String adjudicated) {
		this.adjudicated = adjudicated;
	}

	public String getBundledUnbundledLineNumber() {
		return this.bundledUnbundledLineNumber;
	}

	public void setBundledUnbundledLineNumber(String bundledUnbundledLineNumber) {
		this.bundledUnbundledLineNumber = bundledUnbundledLineNumber;
	}

	public String getModifier1() {
		return this.modifier1;
	}

	public void setModifier1(String modifier1) {
		this.modifier1 = modifier1;
	}

	public String getModifier2() {
		return this.modifier2;
	}

	public void setModifier2(String modifier2) {
		this.modifier2 = modifier2;
	}

	public String getModifier3() {
		return this.modifier3;
	}

	public void setModifier3(String modifier3) {
		this.modifier3 = modifier3;
	}

	public String getModifier4() {
		return this.modifier4;
	}

	public void setModifier4(String modifier4) {
		this.modifier4 = modifier4;
	}

	public String getOhiAdjudicatedDate() {
		return this.ohiAdjudicatedDate;
	}

	public void setOhiAdjudicatedDate(String ohiAdjudicatedDate) {
		this.ohiAdjudicatedDate = ohiAdjudicatedDate;
	}

	public String getOhiPaid() {
		return this.ohiPaid;
	}

	public void setOhiPaid(String ohiPaid) {
		this.ohiPaid = ohiPaid;
	}

	public String getProcedureCode() {
		return this.procedureCode;
	}

	public void setProcedureCode(String procedureCode) {
		this.procedureCode = procedureCode;
	}

	public String getQuantity() {
		return this.quantity;
	}

	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	public String getRevenueCode() {
		return this.revenueCode;
	}

	public void setRevenueCode(String revenueCode) {
		this.revenueCode = revenueCode;
	}

	public String getPayerId() {
    return payerId;
  }

  public void setPayerId(String payerId) {
    this.payerId = payerId;
  }

  public EwvServiceLine getEwvServiceLine() {
		return this.ewvServiceLine;
	}

	public void setEwvServiceLine(EwvServiceLine ewvServiceLine) {
		this.ewvServiceLine = ewvServiceLine;
	}
	
	public Set<EwvServiceLineOhiAdjtmt> getEwvServiceLineOhiAdjtmts() {
		return this.ewvServiceLineOhiAdjtmts;
	}

	public void setEwvServiceLineOhiAdjtmts(Set<EwvServiceLineOhiAdjtmt> ewvServiceLineOhiAdjtmts) {
		this.ewvServiceLineOhiAdjtmts = ewvServiceLineOhiAdjtmts;
	}
	
}