package gov.va.med.hac.edi.ewv2.persistence;


import gov.va.med.hac.edi.ewv2.beans.servicelines.ServiceLine;

import java.io.Serializable;
import javax.persistence.*;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;


/**
 * The persistent class for the EWV_SERVICE_LINES database table.
 * 
 */
@Entity
@Table(name="EWV_SERVICE_LINES")
public class EwvServiceLine implements Serializable, Comparable<EwvServiceLine> {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name="BEGIN_DATE_OF_SERVICE")
	private String beginDateOfService;

	@Column(name="CHARGE")
	private String charge;

	@Column(name="DX1")
	private String dx1;

	@Column(name="DX2")
	private String dx2;

	@Column(name="DX3")
	private String dx3;

	@Column(name="DX4")
	private String dx4;

	@Column(name="END_DATE_OF_SERVICE")
	private String endDateOfService;

	@Column(name="FACILITY_TAX")
	private String facilityTax;

	@Column(name="LINE_NUMBER")
	private Long lineNumber;

	@Column(name="MODIFIER1")
	private String modifier1;

	@Column(name="MODIFIER2")
	private String modifier2;

	@Column(name="MODIFIER3")
	private String modifier3;

	@Column(name="MODIFIER4")
	private String modifier4;

	@Column(name="NDC")
	private String ndc;

	@Column(name="POS")
	private String pos;

	@Column(name="PROCEDURE_CODE")
	private String procedureCode;

	@Column(name="QUANTITY")
	private String quantity;

	@Column(name="REVENUE_CODE")
	private String revenueCode;

	@Column(name="SALES_TAX")
	private String salesTax;

	@Column(name="SERVICE_TAX")
	private String serviceTax;

	private String type;

	//bi-directional many-to-one association to EwvClaim
    @ManyToOne
	@JoinColumn(name="CLAIM_GUID")
	private EwvClaim ewvClaim;

	//bi-directional many-to-one association to EwvServiceLinesDrug
	@OneToMany(mappedBy="ewvServiceLine")
	private Set<EwvServiceLinesDrug> ewvServiceLinesDrugs;

	//bi-directional many-to-one association to EwvServiceLineOhi
	@OneToMany(mappedBy="ewvServiceLine")
	private Set<EwvServiceLineOhi> ewvServiceLineOhis;

	//bi-directional many-to-one association to EwvSlProvider
	@OneToMany(mappedBy="ewvServiceLine")
	private Set<EwvSlProvider> ewvSlProviders;

	//bi-directional many-to-one association to EwvSvcLineDme
	@OneToMany(mappedBy="ewvServiceLine")
	private Set<EwvSvcLineDme> ewvSvcLineDmes;

	//bi-directional many-to-one association to EwvSvcLineTeeth
	@OneToMany(mappedBy="ewvServiceLine")
	private Set<EwvSvcLineTeeth> ewvSvcLineTeeths;
	
    //bi-directional many-to-one association to EwvAmbulanceInfo5010
    @OneToMany(mappedBy="ewvServiceLine")
    private Set<EwvAmbulanceInfo5010> ewvAmbulanceInfo5010;

    public EwvServiceLine() {
    }

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getBeginDateOfService() {
		return this.beginDateOfService;
	}

	public void setBeginDateOfService(String beginDateOfService) {
		this.beginDateOfService = beginDateOfService;
	}

	public String getCharge() {
		return this.charge;
	}

	public void setCharge(String charge) {
		this.charge = charge;
	}

	public String getDx1() {
		return this.dx1;
	}

	public void setDx1(String dx1) {
		this.dx1 = dx1;
	}

	public String getDx2() {
		return this.dx2;
	}

	public void setDx2(String dx2) {
		this.dx2 = dx2;
	}

	public String getDx3() {
		return this.dx3;
	}

	public void setDx3(String dx3) {
		this.dx3 = dx3;
	}

	public String getDx4() {
		return this.dx4;
	}

	public void setDx4(String dx4) {
		this.dx4 = dx4;
	}

	public String getEndDateOfService() {
		return this.endDateOfService;
	}

	public void setEndDateOfService(String endDateOfService) {
		this.endDateOfService = endDateOfService;
	}

	public String getFacilityTax() {
		return this.facilityTax;
	}

	public void setFacilityTax(String facilityTax) {
		this.facilityTax = facilityTax;
	}

    public Long getLineNumber() {
      return this.lineNumber;
  }

  public void setLineNumber(Long lineNumber) {
      this.lineNumber = lineNumber;
  }

	public String getModifier1() {
		return this.modifier1;
	}

	public void setModifier1(String modifier1) {
		this.modifier1 = modifier1;
	}

	public String getModifier2() {
		return this.modifier2;
	}

	public void setModifier2(String modifier2) {
		this.modifier2 = modifier2;
	}

	public String getModifier3() {
		return this.modifier3;
	}

	public void setModifier3(String modifier3) {
		this.modifier3 = modifier3;
	}

	public String getModifier4() {
		return this.modifier4;
	}

	public void setModifier4(String modifier4) {
		this.modifier4 = modifier4;
	}

	public String getNdc() {
		return this.ndc;
	}

	public void setNdc(String ndc) {
		this.ndc = ndc;
	}

	public String getPos() {
		return this.pos;
	}

	public void setPos(String pos) {
		this.pos = pos;
	}

	public String getProcedureCode() {
		return this.procedureCode;
	}

	public void setProcedureCode(String procedureCode) {
		this.procedureCode = procedureCode;
	}

	public String getQuantity() {
		return this.quantity;
	}

	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	public String getRevenueCode() {
		return this.revenueCode;
	}

	public void setRevenueCode(String revenueCode) {
		this.revenueCode = revenueCode;
	}

	public String getSalesTax() {
		return this.salesTax;
	}

	public void setSalesTax(String salesTax) {
		this.salesTax = salesTax;
	}

	public String getServiceTax() {
		return this.serviceTax;
	}

	public void setServiceTax(String serviceTax) {
		this.serviceTax = serviceTax;
	}

	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public EwvClaim getEwvClaim() {
		return this.ewvClaim;
	}

	public void setEwvClaim(EwvClaim ewvClaim) {
		this.ewvClaim = ewvClaim;
	}
	
	public Set<EwvServiceLinesDrug> getEwvServiceLinesDrugs() {
		return this.ewvServiceLinesDrugs;
	}

	public void setEwvServiceLinesDrugs(Set<EwvServiceLinesDrug> ewvServiceLinesDrugs) {
		this.ewvServiceLinesDrugs = ewvServiceLinesDrugs;
	}
	
	public Set<EwvServiceLineOhi> getEwvServiceLineOhis() {
		return this.ewvServiceLineOhis;
	}

	public void setEwvServiceLineOhis(Set<EwvServiceLineOhi> ewvServiceLineOhis) {
		this.ewvServiceLineOhis = ewvServiceLineOhis;
	}
	
	public Set<EwvSlProvider> getEwvSlProviders() {
		return this.ewvSlProviders;
	}

	public void setEwvSlProviders(Set<EwvSlProvider> ewvSlProviders) {
		this.ewvSlProviders = ewvSlProviders;
	}
	
	public Set<EwvSvcLineDme> getEwvSvcLineDmes() {
		return this.ewvSvcLineDmes;
	}

	public void setEwvSvcLineDmes(Set<EwvSvcLineDme> ewvSvcLineDmes) {
		this.ewvSvcLineDmes = ewvSvcLineDmes;
	}
	
	public Set<EwvSvcLineTeeth> getEwvSvcLineTeeths() {
		return this.ewvSvcLineTeeths;
	}

	public void setEwvSvcLineTeeths(Set<EwvSvcLineTeeth> ewvSvcLineTeeths) {
		this.ewvSvcLineTeeths = ewvSvcLineTeeths;
	}
	
    public Set<EwvAmbulanceInfo5010> getEwvAmbulanceInfo5010() {
      return this.ewvAmbulanceInfo5010;
    }

    public void setEwvAmbulanceInfo5010(Set<EwvAmbulanceInfo5010> ewvAmbulanceInfo5010) {
      this.ewvAmbulanceInfo5010 = ewvAmbulanceInfo5010;
    }
  
//    // Used in sorting
//    public int compareToOld(EwvServiceLine line)
//    {
//      SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy");
//      int equal = 0;
//      int mineLess = -1;
//      int mineGreater = 1;
//      
//      int returnValue = equal;
//      
//      Date myFromDate = null;
//      Date theirFromDate = null;
//      String myProcedureCode = null;
//      String theirProcedureCode = null;
//      try {
//        if (beginDateOfService != null && line.getBeginDateOfService() != null) {
//          myFromDate = formatter.parse(beginDateOfService);
//          theirFromDate = formatter.parse(line.getBeginDateOfService());
//          returnValue = myFromDate.compareTo(theirFromDate);
//          if (returnValue == equal) {
//            myProcedureCode = procedureCode;
//            theirProcedureCode = line.getProcedureCode();
//            if (myProcedureCode != null && theirProcedureCode != null) {
//              returnValue = myProcedureCode.compareToIgnoreCase(theirProcedureCode);
//            } else if (myProcedureCode == null && theirProcedureCode != null) {
//              returnValue = mineLess;
//            } else if (myProcedureCode != null && theirProcedureCode == null) {
//              returnValue = mineGreater;
//            }
//          }
//        }
//      } catch (Exception e) {
//        // If these dates cannot be parsed for sorting, they could not be parsed for display
//        beginDateOfService = "Error";
//        returnValue = equal;
//      }
//
//      return returnValue;
//    }

    // Used in sorting
    public int compareTo(EwvServiceLine line)
    {
      // Constants
      int equal = 0;
      int mineLess = -1;
      int mineGreater = 1;

      // Value to return
      int returnValue = equal;

      try {
        // First, try date
        String myDateString = this.beginDateOfService;
        String theirDateString = line.getBeginDateOfService();
        
        // If my date is present
        if (myDateString != null && !myDateString.isEmpty()) {
          // If their date is present
          if (theirDateString != null && !theirDateString.isEmpty()) {
            // Both dates present = parse and compare the two dates
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy");
            Date myFromDate = formatter.parse(myDateString);
            Date theirFromDate = formatter.parse(theirDateString);
            returnValue = myFromDate.compareTo(theirFromDate);
          } else {
            // Only my date is present
            returnValue = mineGreater;
          }
        } else {
          if (theirDateString != null && !theirDateString.isEmpty()) {
            // Only their date is present
            returnValue = mineLess;
          }
        } // end of trying begin dates
        
//        Change requested in mini-spec on 4/14/2011 or before.
//        // Next, try procedure code
//        if (returnValue == equal) {
//          String myProcedureCode = this.procedureCode;
//          String theirProcedureCode = line.getProcedureCode();
//  
//          // If my procedure code is present
//          if (myProcedureCode != null && !myProcedureCode.isEmpty()) {
//            // If their date is present
//            if (theirProcedureCode != null && !theirProcedureCode.isEmpty()) {
//              // Both codes present = compare the two codes
//              returnValue = myProcedureCode.compareTo(theirProcedureCode);
//            } else {
//              // Only my code is present
//              returnValue = mineGreater;
//            }
//          } else {
//            if (theirProcedureCode != null && !theirProcedureCode.isEmpty()) {
//              // Only their code is present
//              returnValue = mineLess;
//            }
//          }
//        } // end of trying procedure codes
         
        // Finally, try line number
        if (returnValue == equal) {
          Long myLineNumber = this.lineNumber;
          Long theirLineNumber = line.getLineNumber();
  
          // If my line number is present
          if (myLineNumber != null) {
            // If their line number is present
            if (theirLineNumber != null) {
              // Both line numbers present = parse and compare the two line numbers
              returnValue = myLineNumber.compareTo(theirLineNumber);
            } else {
              // Only my line number is present
              returnValue = mineGreater;
            }
          } else {
            if (theirLineNumber != null) {
              // Only their line number is present
              returnValue = mineLess;
            }
          } // end of trying begin dates
        }
      } catch (Exception e) {
        // If these dates cannot be parsed for sorting, they could not be parsed for display
        beginDateOfService = "Error";
        returnValue = equal;
      }

      return returnValue;
    }
}