package gov.va.med.hac.edi.ewv2.persistence;


import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the EWV_PROCEDURE_CODES database table.
 * 
 */
@Entity
@Table(name = "EWV_PROCEDURE_CODES")
public class EwvProcedureCode implements Serializable
{
    private static final long serialVersionUID = 1L;
    
    @Id
    private long              guid;
    
    @Column(name = "PROCEDURE_CODE")
    private String            procedureCode;
    
    @Column(name = "PROCEDURE_DATE")
    private String            procedureDate;
    
    @Column(name = "PROC_SEQ")
    private Long              procedureSequence;
    
    // bi-directional many-to-one association to EwvClaim
    @ManyToOne
    @JoinColumn(name = "CLAIM_GUID")
    private EwvClaim          ewvClaim;
    
    public EwvProcedureCode()
    {
    }
    
    public long getGuid()
    {
        return this.guid;
    }
    
    public void setGuid(long guid)
    {
        this.guid = guid;
    }
    
    public String getProcedureCode()
    {
        return this.procedureCode;
    }
    
    public void setProcedureCode(String procedureCode)
    {
        this.procedureCode = procedureCode;
    }
    
    public String getProcedureDate()
    {
        return this.procedureDate;
    }
    
    public void setProcedureDate(String procedureDate)
    {
        this.procedureDate = procedureDate;
    }
    
    public EwvClaim getEwvClaim()
    {
        return this.ewvClaim;
    }
    
    public void setEwvClaim(EwvClaim ewvClaim)
    {
        this.ewvClaim = ewvClaim;
    }
    
    public Long getProcedureSequence()
    {
        return ((procedureSequence == null) ? 0L : procedureSequence);
    }
    
    public void setProcedureSequence(Long diagnosisSequence)
    {
        this.procedureSequence = ((procedureSequence == null) ? 0L : procedureSequence);
    }
    
}