package gov.va.med.hac.edi.ewv2.persistence;


import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the EWV_HEALTH_INFORMATION database table.
 * 
 */
@Entity
@Table(name = "EWV_HEALTH_INFORMATION")
public class EwvHealthInformation implements Serializable
{
    private static final long serialVersionUID = 1L;
    
    @Id
    private long              guid;
    
    @Column(name = "AMOUNT")
    private String            amount;
    
    @Column(name = "CLAIM_DATE")
    private String            claimDate;
    
    @Column(name = "CODE")
    private String            code;
    
    @Column(name = "DESCRIPTION")
    private String            description;
    
    @Column(name = "FORMAT")
    private String            format;
    
    @Column(name = "HEALTH_CARE_TYPE")
    private String            healthCareType;
    
    @Column(name = "QUALIFIER")
    private String            qualifier;
    
    @Column(name = "HI_SEQ")
    private Long              healthInformationSequence;
    
    // bi-directional many-to-one association to EwvClaim
    @ManyToOne
    @JoinColumn(name = "CLAIM_GUID")
    private EwvClaim          ewvClaim;
    
    public EwvHealthInformation()
    {
    }
    
    public long getGuid()
    {
        return this.guid;
    }
    
    public void setGuid(long guid)
    {
        this.guid = guid;
    }
    
    public String getAmount()
    {
        return this.amount;
    }
    
    public void setAmount(String amount)
    {
        this.amount = amount;
    }
    
    public String getClaimDate()
    {
        return this.claimDate;
    }
    
    public void setClaimDate(String claimDate)
    {
        this.claimDate = claimDate;
    }
    
    public String getCode()
    {
        return this.code;
    }
    
    public void setCode(String code)
    {
        this.code = code;
    }
    
    public String getDescription()
    {
        return this.description;
    }
    
    public void setDescription(String description)
    {
        this.description = description;
    }
    
    public String getFormat()
    {
        return this.format;
    }
    
    public void setFormat(String format)
    {
        this.format = format;
    }
    
    public String getHealthCareType()
    {
        return this.healthCareType;
    }
    
    public void setHealthCareType(String healthCareType)
    {
        this.healthCareType = healthCareType;
    }
    
    public String getQualifier()
    {
        return this.qualifier;
    }
    
    public void setQualifier(String qualifier)
    {
        this.qualifier = qualifier;
    }
    
    public EwvClaim getEwvClaim()
    {
        return this.ewvClaim;
    }
    
    public void setEwvClaim(EwvClaim ewvClaim)
    {
        this.ewvClaim = ewvClaim;
    }
    
    public Long getHealthInformationSequence()
    {
        return healthInformationSequence;
    }
    
    public void setHealthInformationSequence(Long healthInformationSequence)
    {
        this.healthInformationSequence = healthInformationSequence;
    }
    
}