package gov.va.med.hac.edi.ewv2.persistence;

import java.io.Serializable;
import javax.persistence.*;

import java.math.BigDecimal;

/**
 * The persistent class for the EWV_E_CODES_5010 database table.
 * 
 */
@Entity
@Table(name="EWV_E_CODES_5010")
public class EwvECode5010 implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name="E_CODE")
	private String eCode;

	@Column(name="SEQUENCE_NUM")
	private Long sequenceNum;

  @Column(name = "POA_INDICATOR_5010")
  private String poaIndicator_5010;
  
  // bi-directional many-to-one association to EwvClaim
  @ManyToOne
  @JoinColumn(name = "CLAIM_GUID")
  private EwvClaim ewvClaim;
  
  public EwvECode5010() {
  }

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getECode() {
		return this.eCode;
	}

	public void setECode(String eCode) {
		this.eCode = eCode;
	}

	public Long getSequenceNum() {
		return this.sequenceNum;
	}

	public void setSequenceNum(Long sequenceNum) {
		this.sequenceNum = sequenceNum;
	}

  public EwvClaim getEwvClaim()
  {
      return this.ewvClaim;
  }
  
  public void setEwvClaim(EwvClaim ewvClaim)
  {
      this.ewvClaim = ewvClaim;
  }
  
  public String getPoaIndicator_5010() {
    return poaIndicator_5010;
  }

  public void setPoaIndicator_5010(String poaIndicator_5010) {
    this.poaIndicator_5010 = poaIndicator_5010;
  }


}