package gov.va.med.hac.edi.ewv2.persistence;


import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the EWV_DIAGNOSIS_CODES database table.
 * 
 */
@Entity
@Table(name = "EWV_DIAGNOSIS_CODES")
public class EwvDiagnosisCode implements Serializable
{
    private static final long serialVersionUID = 1L;
    
    @Id
    private long              guid;
    
    @Column(name = "DIAGNOSIS_CODE")
    private String            diagnosisCode;
    
    @Column(name = "DIAG_SEQ")
    private Long              diagnosisSequence;
    
    @Column(name = "POA_INDICATOR_5010")
    private String             poaIndicator_5010;
    
    // bi-directional many-to-one association to EwvClaim
    @ManyToOne
    @JoinColumn(name = "CLAIM_GUID")
    private EwvClaim          ewvClaim;
    
    public EwvDiagnosisCode()
    {
    }
    
    public long getGuid()
    {
        return this.guid;
    }
    
    public void setGuid(long guid)
    {
        this.guid = guid;
    }
    
    public String getDiagnosisCode()
    {
        return this.diagnosisCode;
    }
    
    public void setDiagnosisCode(String diagnosisCode)
    {
        this.diagnosisCode = diagnosisCode;
    }
    
    public String getPoaIndicator_5010() {
      return poaIndicator_5010;
    }

    public void setPoaIndicator_5010(String poaIndicator_5010) {
      this.poaIndicator_5010 = poaIndicator_5010;
    }

    public EwvClaim getEwvClaim()
    {
        return this.ewvClaim;
    }
    
    public void setEwvClaim(EwvClaim ewvClaim)
    {
        this.ewvClaim = ewvClaim;
    }
    
    public Long getDiagnosisSequence()
    {
        return ((diagnosisSequence == null) ? 0L:diagnosisSequence );
    }
    
    public void setDiagnosisSequence(Long diagnosisSequence)
    {
        this.diagnosisSequence = ((diagnosisSequence == null) ? 0L:diagnosisSequence );
    }
    
}