package gov.va.med.hac.edi.ewv2.persistence;


import java.io.Serializable;
import javax.persistence.*;
import java.util.Set;


/**
 * The persistent class for the EWV_CLAIM_OHIS database table.
 * 
 */
@Entity
@Table(name="EWV_CLAIM_OHIS")
public class EwvClaimOhi implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name="BENEFITS_ASSIGNMENT_INDICATOR")
	private String benefitsAssignmentIndicator;

	@Column(name="CLAIM_ADJUSTMENT_DATE")
	private String claimAdjustmentDate;

	@Column(name="COB_APPROVED_AMT")
	private String cobApprovedAmt;

	@Column(name="COB_MEDICARE_A_TRUST_FUND")
	private String cobMedicareATrustFund;

	@Column(name="COB_MEDICARE_B_TRUST_FUND")
	private String cobMedicareBTrustFund;

	@Column(name="COB_MEDICARE_PAID_AMT_100")
	private String cobMedicarePaidAmt100;

	@Column(name="COB_MEDICARE_PAID_AMT_80")
	private String cobMedicarePaidAmt80;

	@Column(name="COB_PATIENT_PAID_AMT")
	private String cobPatientPaidAmt;

	@Column(name="COB_PATIENT_RESPONSIBILITY")
	private String cobPatientResponsibility;

	@Column(name="COB_PAYER_PAID_AMT")
	private String cobPayerPaidAmt;

	@Column(name="COB_SUBMITTED_CHARGES")
	private String cobSubmittedCharges;

	@Column(name="COB_TOTAL_ALLOWED_AMT")
	private String cobTotalAllowedAmt;

	@Column(name="COB_TOTAL_DENIED_AMT")
	private String cobTotalDeniedAmt;

	@Column(name="COB_TOTAL_MEDICARE_PAID_AMT")
	private String cobTotalMedicarePaidAmt;

	@Column(name="COB_TOTAL_NONCOVERED_AMT")
	private String cobTotalNoncoveredAmt;

	@Column(name="FILING_INDICATOR")
	private String filingIndicator;

	@Column(name="INP_CLAIM_DISPROPOR_SHARE")
	private String inpClaimDisproporShare;

	@Column(name="INP_CLAIM_DRG_AMT")
	private String inpClaimDrgAmt;

	@Column(name="INP_CLAIM_INDIRECT_TEACH_AMT")
	private String inpClaimIndirectTeachAmt;

	@Column(name="INP_CLAIM_PPS_CAPITAL_AMT")
	private String inpClaimPpsCapitalAmt;

	@Column(name="INP_COST_REPORT_DAY_COUNT")
	private String inpCostReportDayCount;

	@Column(name="INP_COVERED_DAYS")
	private String inpCoveredDays;

	@Column(name="INP_LIFETIME_PSYCHIATRIC_DAYS")
	private String inpLifetimePsychiatricDays;

	@Column(name="INP_LIFETIME_RESERVE_DAYS")
	private String inpLifetimeReserveDays;

	@Column(name="INP_MSP_PASS_THROUGH_AMT")
	private String inpMspPassThroughAmt;

	@Column(name="INP_NONPAYABLE_PROF_COMPONENT")
	private String inpNonpayableProfComponent;

	@Column(name="INP_OLD_CAPITAL_AMT")
	private String inpOldCapitalAmt;

	@Column(name="INP_PPS_CAPITAL_DSH_DRG_AMT")
	private String inpPpsCapitalDshDrgAmt;

	@Column(name="INP_PPS_CAPITAL_EXCEPTION_AMT")
	private String inpPpsCapitalExceptionAmt;

	@Column(name="INP_PPS_CAPITAL_FSP_DRG_AMT")
	private String inpPpsCapitalFspDrgAmt;

	@Column(name="INP_PPS_CAPITAL_HSP_DRG_AMT")
	private String inpPpsCapitalHspDrgAmt;

	@Column(name="INP_PPS_CAPITAL_IME_AMT")
	private String inpPpsCapitalImeAmt;

	@Column(name="INP_PPS_CAPITAL_OUTLR_AMT")
	private String inpPpsCapitalOutlrAmt;

	@Column(name="INP_PPS_OPER_FED_SPEC_DRG_AMT")
	private String inpPpsOperFedSpecDrgAmt;

	@Column(name="INP_PPS_OPER_HOSP_SPEC_DRG_AMT")
	private String inpPpsOperHospSpecDrgAmt;

	@Column(name="INP_REMITTANCE_REMARK_CODE_1")
	private String inpRemittanceRemarkCode1;

	@Column(name="INP_REMITTANCE_REMARK_CODE_2")
	private String inpRemittanceRemarkCode2;

	@Column(name="INP_REMITTANCE_REMARK_CODE_3")
	private String inpRemittanceRemarkCode3;

	@Column(name="INP_REMITTANCE_REMARK_CODE_4")
	private String inpRemittanceRemarkCode4;

	@Column(name="INP_REMITTANCE_REMARK_CODE_5")
	private String inpRemittanceRemarkCode5;

	@Column(name="INP_REMITTANCE_REMARK_DESC_3")
	private String inpRemittanceRemarkDesc3;

	@Column(name="INP_REMITTANCE_REMARK_DESC1")
	private String inpRemittanceRemarkDesc1;

	@Column(name="INP_REMITTANCE_REMARK_DESC2")
	private String inpRemittanceRemarkDesc2;

	@Column(name="INP_REMITTANCE_REMARK_DESC4")
	private String inpRemittanceRemarkDesc4;

	@Column(name="INP_REMITTANCE_REMARK_DESC5")
	private String inpRemittanceRemarkDesc5;

	@Column(name="INSURANCE_TYPE")
	private String insuranceType;

	@Column(name="OHI_GROUP_NAME")
	private String ohiGroupName;

	@Column(name="OHI_PAYER_ID")
	private String ohiPayerId;

	@Column(name="OPT_CLAIM_HCPCS_PAYABLE_AMT")
	private String optClaimHcpcsPayableAmt;

	@Column(name="OPT_ESRD_PAID_AMT")
	private String optEsrdPaidAmt;

	@Column(name="OPT_NONPAYABLE_PROF_COMPONENT")
	private String optNonpayableProfComponent;

	@Column(name="OPT_REIMBURSEMENT_RATE")
	private String optReimbursementRate;

	@Column(name="OPT_REMITTANCE_REMARK_CODE1")
	private String optRemittanceRemarkCode1;

	@Column(name="OPT_REMITTANCE_REMARK_CODE2")
	private String optRemittanceRemarkCode2;

	@Column(name="OPT_REMITTANCE_REMARK_CODE3")
	private String optRemittanceRemarkCode3;

	@Column(name="OPT_REMITTANCE_REMARK_CODE4")
	private String optRemittanceRemarkCode4;

	@Column(name="OPT_REMITTANCE_REMARK_CODE5")
	private String optRemittanceRemarkCode5;

	@Column(name="OPT_REMITTANCE_REMARK_DESC1")
	private String optRemittanceRemarkDesc1;

	@Column(name="OPT_REMITTANCE_REMARK_DESC2")
	private String optRemittanceRemarkDesc2;

	@Column(name="OPT_REMITTANCE_REMARK_DESC3")
	private String optRemittanceRemarkDesc3;

	@Column(name="OPT_REMITTANCE_REMARK_DESC4")
	private String optRemittanceRemarkDesc4;

	@Column(name="OPT_REMITTANCE_REMARK_DESC5")
	private String optRemittanceRemarkDesc5;

	@Column(name="OTHER_PAYER_NAME")
	private String otherPayerName;

	@Column(name="PAYMENT_SEQUENCE_INDICATOR")
	private String paymentSequenceIndicator;

	//bi-directional many-to-one association to EwvClaimLevelAdjustment
	@OneToMany(fetch = FetchType.EAGER,mappedBy="ewvClaimOhi")
	private Set<EwvClaimLevelAdjustment> ewvClaimLevelAdjustments;

	//bi-directional many-to-one association to EwvClaim
    @ManyToOne
	@JoinColumn(name="CLAIM_GUID")
	private EwvClaim ewvClaim;

    public EwvClaimOhi() {
    }

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getBenefitsAssignmentIndicator() {
		return this.benefitsAssignmentIndicator;
	}

	public void setBenefitsAssignmentIndicator(String benefitsAssignmentIndicator) {
		this.benefitsAssignmentIndicator = benefitsAssignmentIndicator;
	}

	public String getClaimAdjustmentDate() {
		return this.claimAdjustmentDate;
	}

	public void setClaimAdjustmentDate(String claimAdjustmentDate) {
		this.claimAdjustmentDate = claimAdjustmentDate;
	}

	public String getCobApprovedAmt() {
		return this.cobApprovedAmt;
	}

	public void setCobApprovedAmt(String cobApprovedAmt) {
		this.cobApprovedAmt = cobApprovedAmt;
	}

	public String getCobMedicareATrustFund() {
		return this.cobMedicareATrustFund;
	}

	public void setCobMedicareATrustFund(String cobMedicareATrustFund) {
		this.cobMedicareATrustFund = cobMedicareATrustFund;
	}

	public String getCobMedicareBTrustFund() {
		return this.cobMedicareBTrustFund;
	}

	public void setCobMedicareBTrustFund(String cobMedicareBTrustFund) {
		this.cobMedicareBTrustFund = cobMedicareBTrustFund;
	}

	public String getCobMedicarePaidAmt100() {
		return this.cobMedicarePaidAmt100;
	}

	public void setCobMedicarePaidAmt100(String cobMedicarePaidAmt100) {
		this.cobMedicarePaidAmt100 = cobMedicarePaidAmt100;
	}

	public String getCobMedicarePaidAmt80() {
		return this.cobMedicarePaidAmt80;
	}

	public void setCobMedicarePaidAmt80(String cobMedicarePaidAmt80) {
		this.cobMedicarePaidAmt80 = cobMedicarePaidAmt80;
	}

	public String getCobPatientPaidAmt() {
		return this.cobPatientPaidAmt;
	}

	public void setCobPatientPaidAmt(String cobPatientPaidAmt) {
		this.cobPatientPaidAmt = cobPatientPaidAmt;
	}

	public String getCobPatientResponsibility() {
		return this.cobPatientResponsibility;
	}

	public void setCobPatientResponsibility(String cobPatientResponsibility) {
		this.cobPatientResponsibility = cobPatientResponsibility;
	}

	public String getCobPayerPaidAmt() {
		return this.cobPayerPaidAmt;
	}

	public void setCobPayerPaidAmt(String cobPayerPaidAmt) {
		this.cobPayerPaidAmt = cobPayerPaidAmt;
	}

	public String getCobSubmittedCharges() {
		return this.cobSubmittedCharges;
	}

	public void setCobSubmittedCharges(String cobSubmittedCharges) {
		this.cobSubmittedCharges = cobSubmittedCharges;
	}

	public String getCobTotalAllowedAmt() {
		return this.cobTotalAllowedAmt;
	}

	public void setCobTotalAllowedAmt(String cobTotalAllowedAmt) {
		this.cobTotalAllowedAmt = cobTotalAllowedAmt;
	}

	public String getCobTotalDeniedAmt() {
		return this.cobTotalDeniedAmt;
	}

	public void setCobTotalDeniedAmt(String cobTotalDeniedAmt) {
		this.cobTotalDeniedAmt = cobTotalDeniedAmt;
	}

	public String getCobTotalMedicarePaidAmt() {
		return this.cobTotalMedicarePaidAmt;
	}

	public void setCobTotalMedicarePaidAmt(String cobTotalMedicarePaidAmt) {
		this.cobTotalMedicarePaidAmt = cobTotalMedicarePaidAmt;
	}

	public String getCobTotalNoncoveredAmt() {
		return this.cobTotalNoncoveredAmt;
	}

	public void setCobTotalNoncoveredAmt(String cobTotalNoncoveredAmt) {
		this.cobTotalNoncoveredAmt = cobTotalNoncoveredAmt;
	}

	public String getFilingIndicator() {
		return this.filingIndicator;
	}

	public void setFilingIndicator(String filingIndicator) {
		this.filingIndicator = filingIndicator;
	}

	public String getInpClaimDisproporShare() {
		return this.inpClaimDisproporShare;
	}

	public void setInpClaimDisproporShare(String inpClaimDisproporShare) {
		this.inpClaimDisproporShare = inpClaimDisproporShare;
	}

	public String getInpClaimDrgAmt() {
		return this.inpClaimDrgAmt;
	}

	public void setInpClaimDrgAmt(String inpClaimDrgAmt) {
		this.inpClaimDrgAmt = inpClaimDrgAmt;
	}

	public String getInpClaimIndirectTeachAmt() {
		return this.inpClaimIndirectTeachAmt;
	}

	public void setInpClaimIndirectTeachAmt(String inpClaimIndirectTeachAmt) {
		this.inpClaimIndirectTeachAmt = inpClaimIndirectTeachAmt;
	}

	public String getInpClaimPpsCapitalAmt() {
		return this.inpClaimPpsCapitalAmt;
	}

	public void setInpClaimPpsCapitalAmt(String inpClaimPpsCapitalAmt) {
		this.inpClaimPpsCapitalAmt = inpClaimPpsCapitalAmt;
	}

	public String getInpCostReportDayCount() {
		return this.inpCostReportDayCount;
	}

	public void setInpCostReportDayCount(String inpCostReportDayCount) {
		this.inpCostReportDayCount = inpCostReportDayCount;
	}

	public String getInpCoveredDays() {
		return this.inpCoveredDays;
	}

	public void setInpCoveredDays(String inpCoveredDays) {
		this.inpCoveredDays = inpCoveredDays;
	}

	public String getInpLifetimePsychiatricDays() {
		return this.inpLifetimePsychiatricDays;
	}

	public void setInpLifetimePsychiatricDays(String inpLifetimePsychiatricDays) {
		this.inpLifetimePsychiatricDays = inpLifetimePsychiatricDays;
	}

	public String getInpLifetimeReserveDays() {
		return this.inpLifetimeReserveDays;
	}

	public void setInpLifetimeReserveDays(String inpLifetimeReserveDays) {
		this.inpLifetimeReserveDays = inpLifetimeReserveDays;
	}

	public String getInpMspPassThroughAmt() {
		return this.inpMspPassThroughAmt;
	}

	public void setInpMspPassThroughAmt(String inpMspPassThroughAmt) {
		this.inpMspPassThroughAmt = inpMspPassThroughAmt;
	}

	public String getInpNonpayableProfComponent() {
		return this.inpNonpayableProfComponent;
	}

	public void setInpNonpayableProfComponent(String inpNonpayableProfComponent) {
		this.inpNonpayableProfComponent = inpNonpayableProfComponent;
	}

	public String getInpOldCapitalAmt() {
		return this.inpOldCapitalAmt;
	}

	public void setInpOldCapitalAmt(String inpOldCapitalAmt) {
		this.inpOldCapitalAmt = inpOldCapitalAmt;
	}

	public String getInpPpsCapitalDshDrgAmt() {
		return this.inpPpsCapitalDshDrgAmt;
	}

	public void setInpPpsCapitalDshDrgAmt(String inpPpsCapitalDshDrgAmt) {
		this.inpPpsCapitalDshDrgAmt = inpPpsCapitalDshDrgAmt;
	}

	public String getInpPpsCapitalExceptionAmt() {
		return this.inpPpsCapitalExceptionAmt;
	}

	public void setInpPpsCapitalExceptionAmt(String inpPpsCapitalExceptionAmt) {
		this.inpPpsCapitalExceptionAmt = inpPpsCapitalExceptionAmt;
	}

	public String getInpPpsCapitalFspDrgAmt() {
		return this.inpPpsCapitalFspDrgAmt;
	}

	public void setInpPpsCapitalFspDrgAmt(String inpPpsCapitalFspDrgAmt) {
		this.inpPpsCapitalFspDrgAmt = inpPpsCapitalFspDrgAmt;
	}

	public String getInpPpsCapitalHspDrgAmt() {
		return this.inpPpsCapitalHspDrgAmt;
	}

	public void setInpPpsCapitalHspDrgAmt(String inpPpsCapitalHspDrgAmt) {
		this.inpPpsCapitalHspDrgAmt = inpPpsCapitalHspDrgAmt;
	}

	public String getInpPpsCapitalImeAmt() {
		return this.inpPpsCapitalImeAmt;
	}

	public void setInpPpsCapitalImeAmt(String inpPpsCapitalImeAmt) {
		this.inpPpsCapitalImeAmt = inpPpsCapitalImeAmt;
	}

	public String getInpPpsCapitalOutlrAmt() {
		return this.inpPpsCapitalOutlrAmt;
	}

	public void setInpPpsCapitalOutlrAmt(String inpPpsCapitalOutlrAmt) {
		this.inpPpsCapitalOutlrAmt = inpPpsCapitalOutlrAmt;
	}

	public String getInpPpsOperFedSpecDrgAmt() {
		return this.inpPpsOperFedSpecDrgAmt;
	}

	public void setInpPpsOperFedSpecDrgAmt(String inpPpsOperFedSpecDrgAmt) {
		this.inpPpsOperFedSpecDrgAmt = inpPpsOperFedSpecDrgAmt;
	}

	public String getInpPpsOperHospSpecDrgAmt() {
		return this.inpPpsOperHospSpecDrgAmt;
	}

	public void setInpPpsOperHospSpecDrgAmt(String inpPpsOperHospSpecDrgAmt) {
		this.inpPpsOperHospSpecDrgAmt = inpPpsOperHospSpecDrgAmt;
	}

	public String getInpRemittanceRemarkCode1() {
		return this.inpRemittanceRemarkCode1;
	}

	public void setInpRemittanceRemarkCode1(String inpRemittanceRemarkCode1) {
		this.inpRemittanceRemarkCode1 = inpRemittanceRemarkCode1;
	}

	public String getInpRemittanceRemarkCode2() {
		return this.inpRemittanceRemarkCode2;
	}

	public void setInpRemittanceRemarkCode2(String inpRemittanceRemarkCode2) {
		this.inpRemittanceRemarkCode2 = inpRemittanceRemarkCode2;
	}

	public String getInpRemittanceRemarkCode3() {
		return this.inpRemittanceRemarkCode3;
	}

	public void setInpRemittanceRemarkCode3(String inpRemittanceRemarkCode3) {
		this.inpRemittanceRemarkCode3 = inpRemittanceRemarkCode3;
	}

	public String getInpRemittanceRemarkCode4() {
		return this.inpRemittanceRemarkCode4;
	}

	public void setInpRemittanceRemarkCode4(String inpRemittanceRemarkCode4) {
		this.inpRemittanceRemarkCode4 = inpRemittanceRemarkCode4;
	}

	public String getInpRemittanceRemarkCode5() {
		return this.inpRemittanceRemarkCode5;
	}

	public void setInpRemittanceRemarkCode5(String inpRemittanceRemarkCode5) {
		this.inpRemittanceRemarkCode5 = inpRemittanceRemarkCode5;
	}

	public String getInpRemittanceRemarkDesc3() {
		return this.inpRemittanceRemarkDesc3;
	}

	public void setInpRemittanceRemarkDesc3(String inpRemittanceRemarkDesc3) {
		this.inpRemittanceRemarkDesc3 = inpRemittanceRemarkDesc3;
	}

	public String getInpRemittanceRemarkDesc1() {
		return this.inpRemittanceRemarkDesc1;
	}

	public void setInpRemittanceRemarkDesc1(String inpRemittanceRemarkDesc1) {
		this.inpRemittanceRemarkDesc1 = inpRemittanceRemarkDesc1;
	}

	public String getInpRemittanceRemarkDesc2() {
		return this.inpRemittanceRemarkDesc2;
	}

	public void setInpRemittanceRemarkDesc2(String inpRemittanceRemarkDesc2) {
		this.inpRemittanceRemarkDesc2 = inpRemittanceRemarkDesc2;
	}

	public String getInpRemittanceRemarkDesc4() {
		return this.inpRemittanceRemarkDesc4;
	}

	public void setInpRemittanceRemarkDesc4(String inpRemittanceRemarkDesc4) {
		this.inpRemittanceRemarkDesc4 = inpRemittanceRemarkDesc4;
	}

	public String getInpRemittanceRemarkDesc5() {
		return this.inpRemittanceRemarkDesc5;
	}

	public void setInpRemittanceRemarkDesc5(String inpRemittanceRemarkDesc5) {
		this.inpRemittanceRemarkDesc5 = inpRemittanceRemarkDesc5;
	}

	public String getInsuranceType() {
		return this.insuranceType;
	}

	public void setInsuranceType(String insuranceType) {
		this.insuranceType = insuranceType;
	}

	public String getOhiGroupName() {
		return this.ohiGroupName;
	}

	public void setOhiGroupName(String ohiGroupName) {
		this.ohiGroupName = ohiGroupName;
	}

	public String getOhiPayerId() {
		return this.ohiPayerId;
	}

	public void setOhiPayerId(String ohiPayerId) {
		this.ohiPayerId = ohiPayerId;
	}

	public String getOptClaimHcpcsPayableAmt() {
		return this.optClaimHcpcsPayableAmt;
	}

	public void setOptClaimHcpcsPayableAmt(String optClaimHcpcsPayableAmt) {
		this.optClaimHcpcsPayableAmt = optClaimHcpcsPayableAmt;
	}

	public String getOptEsrdPaidAmt() {
		return this.optEsrdPaidAmt;
	}

	public void setOptEsrdPaidAmt(String optEsrdPaidAmt) {
		this.optEsrdPaidAmt = optEsrdPaidAmt;
	}

	public String getOptNonpayableProfComponent() {
		return this.optNonpayableProfComponent;
	}

	public void setOptNonpayableProfComponent(String optNonpayableProfComponent) {
		this.optNonpayableProfComponent = optNonpayableProfComponent;
	}

	public String getOptReimbursementRate() {
		return this.optReimbursementRate;
	}

	public void setOptReimbursementRate(String optReimbursementRate) {
		this.optReimbursementRate = optReimbursementRate;
	}

	public String getOptRemittanceRemarkCode1() {
		return this.optRemittanceRemarkCode1;
	}

	public void setOptRemittanceRemarkCode1(String optRemittanceRemarkCode1) {
		this.optRemittanceRemarkCode1 = optRemittanceRemarkCode1;
	}

	public String getOptRemittanceRemarkCode2() {
		return this.optRemittanceRemarkCode2;
	}

	public void setOptRemittanceRemarkCode2(String optRemittanceRemarkCode2) {
		this.optRemittanceRemarkCode2 = optRemittanceRemarkCode2;
	}

	public String getOptRemittanceRemarkCode3() {
		return this.optRemittanceRemarkCode3;
	}

	public void setOptRemittanceRemarkCode3(String optRemittanceRemarkCode3) {
		this.optRemittanceRemarkCode3 = optRemittanceRemarkCode3;
	}

	public String getOptRemittanceRemarkCode4() {
		return this.optRemittanceRemarkCode4;
	}

	public void setOptRemittanceRemarkCode4(String optRemittanceRemarkCode4) {
		this.optRemittanceRemarkCode4 = optRemittanceRemarkCode4;
	}

	public String getOptRemittanceRemarkCode5() {
		return this.optRemittanceRemarkCode5;
	}

	public void setOptRemittanceRemarkCode5(String optRemittanceRemarkCode5) {
		this.optRemittanceRemarkCode5 = optRemittanceRemarkCode5;
	}

	public String getOptRemittanceRemarkDesc1() {
		return this.optRemittanceRemarkDesc1;
	}

	public void setOptRemittanceRemarkDesc1(String optRemittanceRemarkDesc1) {
		this.optRemittanceRemarkDesc1 = optRemittanceRemarkDesc1;
	}

	public String getOptRemittanceRemarkDesc2() {
		return this.optRemittanceRemarkDesc2;
	}

	public void setOptRemittanceRemarkDesc2(String optRemittanceRemarkDesc2) {
		this.optRemittanceRemarkDesc2 = optRemittanceRemarkDesc2;
	}

	public String getOptRemittanceRemarkDesc3() {
		return this.optRemittanceRemarkDesc3;
	}

	public void setOptRemittanceRemarkDesc3(String optRemittanceRemarkDesc3) {
		this.optRemittanceRemarkDesc3 = optRemittanceRemarkDesc3;
	}

	public String getOptRemittanceRemarkDesc4() {
		return this.optRemittanceRemarkDesc4;
	}

	public void setOptRemittanceRemarkDesc4(String optRemittanceRemarkDesc4) {
		this.optRemittanceRemarkDesc4 = optRemittanceRemarkDesc4;
	}

	public String getOptRemittanceRemarkDesc5() {
		return this.optRemittanceRemarkDesc5;
	}

	public void setOptRemittanceRemarkDesc5(String optRemittanceRemarkDesc5) {
		this.optRemittanceRemarkDesc5 = optRemittanceRemarkDesc5;
	}

	public String getOtherPayerName() {
		return this.otherPayerName;
	}

	public void setOtherPayerName(String otherPayerName) {
		this.otherPayerName = otherPayerName;
	}

	public String getPaymentSequenceIndicator() {
		return this.paymentSequenceIndicator;
	}

	public void setPaymentSequenceIndicator(String paymentSequenceIndicator) {
		this.paymentSequenceIndicator = paymentSequenceIndicator;
	}

	public Set<EwvClaimLevelAdjustment> getEwvClaimLevelAdjustments() {
		return this.ewvClaimLevelAdjustments;
	}

	public void setEwvClaimLevelAdjustments(Set<EwvClaimLevelAdjustment> ewvClaimLevelAdjustments) {
		this.ewvClaimLevelAdjustments = ewvClaimLevelAdjustments;
	}
	
	public EwvClaim getEwvClaim() {
		return this.ewvClaim;
	}

	public void setEwvClaim(EwvClaim ewvClaim) {
		this.ewvClaim = ewvClaim;
	}
	
}