package gov.va.med.hac.edi.ewv2.persistence;


import java.io.Serializable;
import javax.persistence.*;


/**
 * The persistent class for the EWV_CLAIM_LEVEL_ADJUSTMENTS database table.
 * 
 */
@Entity
@Table(name="EWV_CLAIM_LEVEL_ADJUSTMENTS")
public class EwvClaimLevelAdjustment implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name="CLAIM_ADJUSTMENT_REASON_CODE")
	private String claimAdjustmentReasonCode;

	@Column(name="CO_AMT")
	private String coAmt;
	
	@Transient
	private String crAmt;

	private String description;

	@Column(name="OA_AMT")
	private String oaAmt;

	@Column(name="PI_AMT")
	private String piAmt;

	@Column(name="PR_AMT")
	private String prAmt;

	@Column(name="QUANTITY")
	private String quantity;

	//bi-directional many-to-one association to EwvClaimOhi
    @ManyToOne
	@JoinColumn(name="OHI_GUID")
	private EwvClaimOhi ewvClaimOhi;

    public EwvClaimLevelAdjustment() {
    }

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getClaimAdjustmentReasonCode() {
		return this.claimAdjustmentReasonCode;
	}

	public void setClaimAdjustmentReasonCode(String claimAdjustmentReasonCode) {
		this.claimAdjustmentReasonCode = claimAdjustmentReasonCode;
	}

	public String getCoAmt() {
		return this.coAmt;
	}

	public void setCoAmt(String coAmt) {
		this.coAmt = coAmt;
	}
	
	public String getCrAmt() {
		return this.crAmt;
	}

	public void setCrAmt(String crAmt) {
		this.crAmt = crAmt;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getOaAmt() {
		return this.oaAmt;
	}

	public void setOaAmt(String oaAmt) {
		this.oaAmt = oaAmt;
	}

	public String getPiAmt() {
		return this.piAmt;
	}

	public void setPiAmt(String piAmt) {
		this.piAmt = piAmt;
	}

	public String getPrAmt() {
		return this.prAmt;
	}

	public void setPrAmt(String prAmt) {
		this.prAmt = prAmt;
	}

	public String getQuantity() {
		return this.quantity;
	}

	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	public EwvClaimOhi getEwvClaimOhi() {
		return this.ewvClaimOhi;
	}

	public void setEwvClaimOhi(EwvClaimOhi ewvClaimOhi) {
		this.ewvClaimOhi = ewvClaimOhi;
	}
	
}