package gov.va.med.hac.edi.ewv2.persistence;

import java.io.Serializable;
import javax.persistence.*;

import java.util.Set;

/**
 * The persistent class for the EWV_CLAIMS database table.
 * 
 */
@Entity
@Table(name="EWV_CLAIMS")
public class EwvClaim implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name="BILLING_VENDOR_ADDRESS_LINE_1")
	private String billingVendorAddressLine1;

	@Column(name="BILLING_VENDOR_ADDRESS_LINE_2")
	private String billingVendorAddressLine2;

	@Column(name="BILLING_VENDOR_CITY")
	private String billingVendorCity;

	@Column(name="BILLING_VENDOR_NAME")
	private String billingVendorName;

	@Column(name="BILLING_VENDOR_NPI")
	private String billingVendorNpi;

	@Column(name="BILLING_VENDOR_POSTAL_CODE")
	private String billingVendorPostalCode;

  @Column(name="BILLING_VENDOR_COUNTRY")
  private String billingVendorCountry;

	@Column(name="BILLING_VENDOR_STATE")
	private String billingVendorState;

	@Column(name="BILLING_VENDOR_TAX_ID_NUM")
	private String billingVendorTaxIdNum;

	@Column(name="BILLING_VENDOR_TAXONOMY_CODE")
	private String billingVendorTaxonomyCode;

	@Column(name="CLAIM_TYPE")
	private String claimType;

	@Column(name="EDI_CLAIM_KEY")
	private String ediClaimKey;

	@Column(name="HCCODES_ADMITTING_DIAGNOSIS")
	private String hccodesAdmittingDiagnosis;

	@Column(name="HCCODES_E_CODE")
	private String hccodesECode;

	@Column(name="HCCODES_POA_NOTES")
	private String hccodesPoaNotes;

	@Column(name="HCCODES_PRINCIPAL_DIAGNOSIS")
	private String hccodesPrincipalDiagnosis;

  @Column(name="HCC_PRINCIPAL_DIAG_POA_5010")
  private String hccodesPrincipalDiagnosisPoa;

	@Column(name="HCCODES_PRINCIPAL_PROC_DATE")
	private String hccodesPrincipalProcDate;

	@Column(name="HCCODES_PRINCIPAL_PROCEDURE")
	private String hccodesPrincipalProcedure;

	@Column(name="HCCODES_REASON_FOR_VISTS")
	private String hccodesReasonForVists;

	@Column(name="INVOICE_ACCIDENT_DATE")
	private String invoiceAccidentDate;

	@Column(name="INVOICE_ACCIDENT_INDICATOR")
	private String invoiceAccidentIndicator;

	@Column(name="INVOICE_ADMISSION_DATE_HOUR")
	private String invoiceAdmissionDateHour;

	@Column(name="INVOICE_ADMISSION_SOURCE")
	private String invoiceAdmissionSource;

	@Column(name="INVOICE_ADMISSION_TYPE")
	private String invoiceAdmissionType;

	@Column(name="INVOICE_ASSIGNMENT_OF_BENEFITS")
	private String invoiceAssignmentOfBenefits;

	@Column(name="INVOICE_DISCHARGE_DATE_HOUR")
	private String invoiceDischargeDateHour;

	@Column(name="INVOICE_FREQUENCY")
	private String invoiceFrequency;

	@Column(name="INVOICE_PATIENT_ACCOUNT_NUM")
	private String invoicePatientAccountNum;

	@Column(name="INVOICE_PATIENT_PAID_AMT")
	private String invoicePatientPaidAmt;

	@Column(name="INVOICE_PATIENT_SIGNATURE")
	private String invoicePatientSignature;

	@Column(name="INVOICE_PATIENT_STATUS")
	private String invoicePatientStatus;

	@Column(name="INVOICE_PREVIOUS_PDI")
	private String invoicePreviousPdi;

	@Column(name="INVOICE_PRIOR_AUTHORIZATION_1")
	private String invoicePriorAuthorization1;

	@Column(name="INVOICE_PRIOR_AUTHORIZATION_2")
	private String invoicePriorAuthorization2;

    @Column(name="INVOICE_REFERRAL_5010")
    private String invoiceReferral_5010;

	@Column(name="INVOICE_PROV_ACCEPTS_ASSIGNMT")
	private String invoiceProvAcceptsAssignmt;

	@Column(name="INVOICE_STATEMENT_FROM_DATE")
	private String invoiceStatementFromDate;

	@Column(name="INVOICE_STATEMENT_TO_DATE")
	private String invoiceStatementToDate;

	@Column(name="INVOICE_TYPE_OF_BILL")
	private String invoiceTypeOfBill;

	@Column(name="MEDICARE_CROSSOVER")
	private String medicareCrossover;

	@Column(name="MEDICARE_ICN")
	private String medicareIcn;

	@Column(name="MEMBER_ID")
	private String memberId;

	@Column(name="PATIENT_ADDRESS_LINE_1")
	private String patientAddressLine1;

	@Column(name="PATIENT_ADDRESS_LINE_2")
	private String patientAddressLine2;

	@Column(name="PATIENT_CITY")
	private String patientCity;

	@Column(name="PATIENT_COUNTRY")
	private String patientCountry;

	@Column(name="PATIENT_DOB")
	private String patientDob;

    @Column(name="PATIENT_DATE_OF_DEATH_5010")
    private String patientDateOfDeath_5010;

	@Column(name="PATIENT_GENDER")
	private String patientGender;

	@Column(name="PATIENT_ID_NUMBER")
	private String patientIdNumber;

	@Column(name="PATIENT_NAME")
	private String patientName;

	@Column(name="PATIENT_POSTAL_CODE")
	private String patientPostalCode;

	@Column(name="PATIENT_STATE")
	private String patientState;

	@Column(name="PCN")
	private String pcn;

	@Column(name="PDI")
	private String pdi;

	@Column(name="POS")
	private String pos;

	@Column(name="SERVICE_VENDOR_ADDRESS_LINE_1")
	private String serviceVendorAddressLine1;

	@Column(name="SERVICE_VENDOR_ADDRESS_LINE_2")
	private String serviceVendorAddressLine2;

	@Column(name="SERVICE_VENDOR_CITY")
	private String serviceVendorCity;

	@Column(name="SERVICE_VENDOR_NAME")
	private String serviceVendorName;

	@Column(name="SERVICE_VENDOR_NPI")
	private String serviceVendorNpi;

	@Column(name="SERVICE_VENDOR_POSTAL_CODE")
	private String serviceVendorPostalCode;

    @Column(name="SERVICE_VENDOR_COUNTRY")
    private String serviceVendorCountry;

	@Column(name="SERVICE_VENDOR_STATE")
	private String serviceVendorState;

	@Column(name="SERVICE_VENDOR_TAX_ID_NUM")
	private String serviceVendorTaxIdNum;

	@Column(name="SVC_LINE_TOTAL_CLAIM_CHARGES")
	private String svcLineTotalClaimCharges;

    // New for 5010
	@Column(name="HCCODES_REASON_VISIT_2_5010")
    private String hccodesReasonForVisit2_5010;

    // New for 5010
    @Column(name="HCCODES_REASON_VISIT_3_5010")
    private String hccodesReasonForVisit3_5010;

	//bi-directional many-to-one association to EwvClaimOhi
	@OneToMany(mappedBy="ewvClaim")
	private Set<EwvClaimOhi> ewvClaimOhis;

	//bi-directional many-to-one association to EwvDiagnosisCode
	@OneToMany(mappedBy="ewvClaim")
	private Set<EwvDiagnosisCode> ewvDiagnosisCodes;

	//bi-directional many-to-one association to EwvHealthInformation
	@OneToMany(mappedBy="ewvClaim")
	private Set<EwvHealthInformation> ewvHealthInformations;

	//bi-directional many-to-one association to EwvProcedureCode
	@OneToMany(mappedBy="ewvClaim")
	private Set<EwvProcedureCode> ewvProcedureCodes;

	//bi-directional many-to-one association to EwvServiceLine
	@OneToMany(mappedBy="ewvClaim")
	private Set<EwvServiceLine> ewvServiceLines;

    //bi-directional many-to-one association to EwvECodes5010
    @OneToMany(mappedBy="ewvClaim")
    private Set<EwvECode5010> ewvECodes5010;

    //bi-directional many-to-one association to EwvAmbulanceInfo5010
    @OneToMany(mappedBy="ewvClaim")
    private Set<EwvAmbulanceInfo5010> ewvAmbulanceInfo5010;

    public EwvClaim() {
    }

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getBillingVendorAddressLine1() {
		return this.billingVendorAddressLine1;
	}

	public void setBillingVendorAddressLine1(String billingVendorAddressLine1) {
		this.billingVendorAddressLine1 = billingVendorAddressLine1;
	}

	public String getBillingVendorAddressLine2() {
		return this.billingVendorAddressLine2;
	}

	public void setBillingVendorAddressLine2(String billingVendorAddressLine2) {
		this.billingVendorAddressLine2 = billingVendorAddressLine2;
	}

	public String getBillingVendorCity() {
		return this.billingVendorCity;
	}

	public void setBillingVendorCity(String billingVendorCity) {
		this.billingVendorCity = billingVendorCity;
	}

	public String getBillingVendorName() {
		return this.billingVendorName;
	}

	public void setBillingVendorName(String billingVendorName) {
		this.billingVendorName = billingVendorName;
	}

	public String getBillingVendorNpi() {
		return this.billingVendorNpi;
	}

	public void setBillingVendorNpi(String billingVendorNpi) {
		this.billingVendorNpi = billingVendorNpi;
	}

	public String getBillingVendorPostalCode() {
		return this.billingVendorPostalCode;
	}

	public void setBillingVendorPostalCode(String billingVendorPostalCode) {
		this.billingVendorPostalCode = billingVendorPostalCode;
	}

	public String getBillingVendorState() {
		return this.billingVendorState;
	}

	public void setBillingVendorState(String billingVendorState) {
		this.billingVendorState = billingVendorState;
	}

	public String getBillingVendorTaxIdNum() {
		return this.billingVendorTaxIdNum;
	}

	public void setBillingVendorTaxIdNum(String billingVendorTaxIdNum) {
		this.billingVendorTaxIdNum = billingVendorTaxIdNum;
	}

	/**
	 * @return the billingVendorTaxonomyCode
	 */
	public String getBillingVendorTaxonomyCode() {
		return billingVendorTaxonomyCode;
	}

	/**
	 * @param billingVendorTaxonomyCode the billingVendorTaxonomyCode to set
	 */
	public void setBillingVendorTaxonomyCode(String billingVendorTaxonomyCode) {
		this.billingVendorTaxonomyCode = billingVendorTaxonomyCode;
	}

	public String getClaimType() {
		return this.claimType;
	}

	public void setClaimType(String claimType) {
		this.claimType = claimType;
	}

	public String getEdiClaimKey() {
		return this.ediClaimKey;
	}

	public void setEdiClaimKey(String ediClaimKey) {
		this.ediClaimKey = ediClaimKey;
	}

	public String getHccodesAdmittingDiagnosis() {
		return this.hccodesAdmittingDiagnosis;
	}

	public void setHccodesAdmittingDiagnosis(String hccodesAdmittingDiagnosis) {
		this.hccodesAdmittingDiagnosis = hccodesAdmittingDiagnosis;
	}

	public String getHccodesECode() {
		return this.hccodesECode;
	}

	public void setHccodesECode(String hccodesECode) {
		this.hccodesECode = hccodesECode;
	}

	public String getHccodesPoaNotes() {
		return this.hccodesPoaNotes;
	}

	public void setHccodesPoaNotes(String hccodesPoaNotes) {
		this.hccodesPoaNotes = hccodesPoaNotes;
	}

	public String getHccodesPrincipalDiagnosis() {
		return this.hccodesPrincipalDiagnosis;
	}

	public void setHccodesPrincipalDiagnosis(String hccodesPrincipalDiagnosis) {
		this.hccodesPrincipalDiagnosis = hccodesPrincipalDiagnosis;
	}

  public String getHccodesPrincipalDiagnosisPoa() {
    return this.hccodesPrincipalDiagnosisPoa;
  }

  public void setHccodesPrincipalDiagnosisPoa(String hccodesPrincipalDiagnosisPoa) {
    this.hccodesPrincipalDiagnosisPoa = hccodesPrincipalDiagnosisPoa;
  }

	public String getHccodesPrincipalProcDate() {
		return this.hccodesPrincipalProcDate;
	}

	public void setHccodesPrincipalProcDate(String hccodesPrincipalProcDate) {
		this.hccodesPrincipalProcDate = hccodesPrincipalProcDate;
	}

	public String getHccodesPrincipalProcedure() {
		return this.hccodesPrincipalProcedure;
	}

	public void setHccodesPrincipalProcedure(String hccodesPrincipalProcedure) {
		this.hccodesPrincipalProcedure = hccodesPrincipalProcedure;
	}

	public String getHccodesReasonForVists() {
		return this.hccodesReasonForVists;
	}

	public void setHccodesReasonForVists(String hccodesReasonForVists) {
		this.hccodesReasonForVists = hccodesReasonForVists;
	}

	public String getHccodesReasonForVisit2_5010() {
    return hccodesReasonForVisit2_5010;
  }

  public void setHccodesReasonForVisit2_5010(String hccodesReasonForVisit2_5010) {
    this.hccodesReasonForVisit2_5010 = hccodesReasonForVisit2_5010;
  }

  public String getHccodesReasonForVisit3_5010() {
    return hccodesReasonForVisit3_5010;
  }

  public void setHccodesReasonForVisit3_5010(String hccodesReasonForVisit3_5010) {
    this.hccodesReasonForVisit3_5010 = hccodesReasonForVisit3_5010;
  }

  public String getInvoiceAccidentDate() {
		return this.invoiceAccidentDate;
	}

	public void setInvoiceAccidentDate(String invoiceAccidentDate) {
		this.invoiceAccidentDate = invoiceAccidentDate;
	}

	public String getInvoiceAccidentIndicator() {
		return this.invoiceAccidentIndicator;
	}

	public void setInvoiceAccidentIndicator(String invoiceAccidentIndicator) {
		this.invoiceAccidentIndicator = invoiceAccidentIndicator;
	}

	public String getInvoiceAdmissionDateHour() {
		return this.invoiceAdmissionDateHour;
	}

	public void setInvoiceAdmissionDateHour(String invoiceAdmissionDateHour) {
		this.invoiceAdmissionDateHour = invoiceAdmissionDateHour;
	}

	public String getInvoiceAdmissionSource() {
		return this.invoiceAdmissionSource;
	}

	public void setInvoiceAdmissionSource(String invoiceAdmissionSource) {
		this.invoiceAdmissionSource = invoiceAdmissionSource;
	}

	public String getInvoiceAdmissionType() {
		return this.invoiceAdmissionType;
	}

	public void setInvoiceAdmissionType(String invoiceAdmissionType) {
		this.invoiceAdmissionType = invoiceAdmissionType;
	}

	public String getInvoiceAssignmentOfBenefits() {
		return this.invoiceAssignmentOfBenefits;
	}

	public void setInvoiceAssignmentOfBenefits(String invoiceAssignmentOfBenefits) {
		this.invoiceAssignmentOfBenefits = invoiceAssignmentOfBenefits;
	}

	public String getInvoiceDischargeDateHour() {
		return this.invoiceDischargeDateHour;
	}

	public void setInvoiceDischargeDateHour(String invoiceDischargeDateHour) {
		this.invoiceDischargeDateHour = invoiceDischargeDateHour;
	}

	public String getInvoiceFrequency() {
		return this.invoiceFrequency;
	}

	public void setInvoiceFrequency(String invoiceFrequency) {
		this.invoiceFrequency = invoiceFrequency;
	}

	public String getInvoicePatientAccountNum() {
		return this.invoicePatientAccountNum;
	}

	public void setInvoicePatientAccountNum(String invoicePatientAccountNum) {
		this.invoicePatientAccountNum = invoicePatientAccountNum;
	}

	public String getInvoicePatientPaidAmt() {
		return this.invoicePatientPaidAmt;
	}

	public void setInvoicePatientPaidAmt(String invoicePatientPaidAmt) {
		this.invoicePatientPaidAmt = invoicePatientPaidAmt;
	}

	public String getInvoicePatientSignature() {
		return this.invoicePatientSignature;
	}

	public void setInvoicePatientSignature(String invoicePatientSignature) {
		this.invoicePatientSignature = invoicePatientSignature;
	}

	public String getInvoicePatientStatus() {
		return this.invoicePatientStatus;
	}

	public void setInvoicePatientStatus(String invoicePatientStatus) {
		this.invoicePatientStatus = invoicePatientStatus;
	}

	public String getInvoicePreviousPdi() {
		return this.invoicePreviousPdi;
	}

	public void setInvoicePreviousPdi(String invoicePreviousPdi) {
		this.invoicePreviousPdi = invoicePreviousPdi;
	}

	public String getInvoicePriorAuthorization1() {
		return this.invoicePriorAuthorization1;
	}

	public void setInvoicePriorAuthorization1(String invoicePriorAuthorization1) {
		this.invoicePriorAuthorization1 = invoicePriorAuthorization1;
	}

	public String getInvoicePriorAuthorization2() {
		return this.invoicePriorAuthorization2;
	}

	public void setInvoicePriorAuthorization2(String invoicePriorAuthorization2) {
		this.invoicePriorAuthorization2 = invoicePriorAuthorization2;
	}

	public String getInvoiceReferral_5010() {
    return invoiceReferral_5010;
  }

  public void setInvoiceReferral_5010(String invoiceReferral_5010) {
    this.invoiceReferral_5010 = invoiceReferral_5010;
  }

  public String getInvoiceProvAcceptsAssignmt() {
		return this.invoiceProvAcceptsAssignmt;
	}

	public void setInvoiceProvAcceptsAssignmt(String invoiceProvAcceptsAssignmt) {
		this.invoiceProvAcceptsAssignmt = invoiceProvAcceptsAssignmt;
	}

	public String getInvoiceStatementFromDate() {
		return this.invoiceStatementFromDate;
	}

	public void setInvoiceStatementFromDate(String invoiceStatementFromDate) {
		this.invoiceStatementFromDate = invoiceStatementFromDate;
	}

	public String getInvoiceStatementToDate() {
		return this.invoiceStatementToDate;
	}

	public void setInvoiceStatementToDate(String invoiceStatementToDate) {
		this.invoiceStatementToDate = invoiceStatementToDate;
	}

	public String getInvoiceTypeOfBill() {
		return this.invoiceTypeOfBill;
	}

	public void setInvoiceTypeOfBill(String invoiceTypeOfBill) {
		this.invoiceTypeOfBill = invoiceTypeOfBill;
	}

	public String getMedicareCrossover() {
		return this.medicareCrossover;
	}

	public void setMedicareCrossover(String medicareCrossover) {
		this.medicareCrossover = medicareCrossover;
	}

	public String getMedicareIcn() {
		return medicareIcn;
	}

	public void setMedicareIcn(String medicareIcn) {
		this.medicareIcn = medicareIcn;
	}

	public String getMemberId() {
		return this.memberId;
	}

	public void setMemberId(String memberId) {
		this.memberId = memberId;
	}

	public String getPatientAddressLine1() {
		return this.patientAddressLine1;
	}

	public void setPatientAddressLine1(String patientAddressLine1) {
		this.patientAddressLine1 = patientAddressLine1;
	}

	public String getPatientAddressLine2() {
		return this.patientAddressLine2;
	}

	public void setPatientAddressLine2(String patientAddressLine2) {
		this.patientAddressLine2 = patientAddressLine2;
	}

	public String getPatientCity() {
		return this.patientCity;
	}

	public void setPatientCity(String patientCity) {
		this.patientCity = patientCity;
	}

	public String getPatientCountry() {
		return this.patientCountry;
	}

	public void setPatientCountry(String patientCountry) {
		this.patientCountry = patientCountry;
	}

	public String getPatientDob() {
		return this.patientDob;
	}

	public void setPatientDob(String patientDob) {
		this.patientDob = patientDob;
	}

	public String getPatientDateOfDeath_5010() {
    return patientDateOfDeath_5010;
  }

  public void setPatientDateOfDeath_5010(String patientDateOfDeath_5010) {
    this.patientDateOfDeath_5010 = patientDateOfDeath_5010;
  }

  public String getPatientGender() {
		return this.patientGender;
	}

	public void setPatientGender(String patientGender) {
		this.patientGender = patientGender;
	}

	public String getPatientIdNumber() {
		return this.patientIdNumber;
	}

	public void setPatientIdNumber(String patientIdNumber) {
		this.patientIdNumber = patientIdNumber;
	}

	public String getPatientName() {
		return this.patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public String getPatientPostalCode() {
		return this.patientPostalCode;
	}

	public void setPatientPostalCode(String patientPostalCode) {
		this.patientPostalCode = patientPostalCode;
	}

	public String getPatientState() {
		return this.patientState;
	}

	public void setPatientState(String patientState) {
		this.patientState = patientState;
	}

	public String getPcn() {
		return this.pcn;
	}

	public void setPcn(String pcn) {
		this.pcn = pcn;
	}

	public String getPdi() {
		return this.pdi;
	}

	public void setPdi(String pdi) {
		this.pdi = pdi;
	}

	public String getPos() {
		return this.pos;
	}

	public void setPos(String pos) {
		this.pos = pos;
	}

	public String getServiceVendorAddressLine1() {
		return this.serviceVendorAddressLine1;
	}

	public void setServiceVendorAddressLine1(String serviceVendorAddressLine1) {
		this.serviceVendorAddressLine1 = serviceVendorAddressLine1;
	}

	public String getServiceVendorAddressLine2() {
		return this.serviceVendorAddressLine2;
	}

	public void setServiceVendorAddressLine2(String serviceVendorAddressLine2) {
		this.serviceVendorAddressLine2 = serviceVendorAddressLine2;
	}

	public String getServiceVendorCity() {
		return this.serviceVendorCity;
	}

	public void setServiceVendorCity(String serviceVendorCity) {
		this.serviceVendorCity = serviceVendorCity;
	}

	public String getServiceVendorName() {
		return this.serviceVendorName;
	}

	public void setServiceVendorName(String serviceVendorName) {
		this.serviceVendorName = serviceVendorName;
	}

	public String getServiceVendorNpi() {
		return this.serviceVendorNpi;
	}

	public void setServiceVendorNpi(String serviceVendorNpi) {
		this.serviceVendorNpi = serviceVendorNpi;
	}

	public String getServiceVendorPostalCode() {
		return this.serviceVendorPostalCode;
	}

	public void setServiceVendorPostalCode(String serviceVendorPostalCode) {
		this.serviceVendorPostalCode = serviceVendorPostalCode;
	}

	public String getServiceVendorState() {
		return this.serviceVendorState;
	}

	public void setServiceVendorState(String serviceVendorState) {
		this.serviceVendorState = serviceVendorState;
	}

	public String getServiceVendorTaxIdNum() {
		return this.serviceVendorTaxIdNum;
	}

	public void setServiceVendorTaxIdNum(String serviceVendorTaxIdNum) {
		this.serviceVendorTaxIdNum = serviceVendorTaxIdNum;
	}

	public String getSvcLineTotalClaimCharges() {
		return this.svcLineTotalClaimCharges;
	}

	public void setSvcLineTotalClaimCharges(String svcLineTotalClaimCharges) {
		this.svcLineTotalClaimCharges = svcLineTotalClaimCharges;
	}

	public Set<EwvClaimOhi> getEwvClaimOhis() {
		return this.ewvClaimOhis;
	}

	public void setEwvClaimOhis(Set<EwvClaimOhi> ewvClaimOhis) {
		this.ewvClaimOhis = ewvClaimOhis;
	}
	
	public Set<EwvDiagnosisCode> getEwvDiagnosisCodes() {
		return this.ewvDiagnosisCodes;
	}

	public void setEwvDiagnosisCodes(Set<EwvDiagnosisCode> ewvDiagnosisCodes) {
		this.ewvDiagnosisCodes = ewvDiagnosisCodes;
	}
	
	public Set<EwvHealthInformation> getEwvHealthInformations() {
		return this.ewvHealthInformations;
	}

	public void setEwvHealthInformations(Set<EwvHealthInformation> ewvHealthInformations) {
		this.ewvHealthInformations = ewvHealthInformations;
	}
	
	public Set<EwvProcedureCode> getEwvProcedureCodes() {
		return this.ewvProcedureCodes;
	}

	public void setEwvProcedureCodes(Set<EwvProcedureCode> ewvProcedureCodes) {
		this.ewvProcedureCodes = ewvProcedureCodes;
	}
	
	public Set<EwvServiceLine> getEwvServiceLines() {
		return this.ewvServiceLines;
	}

	public void setEwvServiceLines(Set<EwvServiceLine> ewvServiceLines) {
		this.ewvServiceLines = ewvServiceLines;
	}
	
    public Set<EwvECode5010> getEwvECodes5010() {
      return this.ewvECodes5010;
    }

    public void setEwvECodes5010(Set<EwvECode5010> ewvECodes5010) {
      this.ewvECodes5010 = ewvECodes5010;
    }
  
    public Set<EwvAmbulanceInfo5010> getEwvAmbulanceInfo5010() {
      return this.ewvAmbulanceInfo5010;
    }

    public void setEwvAmbulanceInfo5010(Set<EwvAmbulanceInfo5010> ewvAmbulanceInfo5010) {
      this.ewvAmbulanceInfo5010 = ewvAmbulanceInfo5010;
    }

    public String getBillingVendorCountry() {
      return billingVendorCountry;
    }

    public void setBillingVendorCountry(String billingVendorCountry) {
      this.billingVendorCountry = billingVendorCountry;
    }

    public String getServiceVendorCountry() {
      return serviceVendorCountry;
    }

    public void setServiceVendorCountry(String serviceVendorCountry) {
      this.serviceVendorCountry = serviceVendorCountry;
    }
  
}