package gov.va.med.hac.edi.ewv2.persistence;

import java.io.Serializable;
import javax.persistence.*;

/**
 * The persistent class for the EWV_AMBULANCE_INFO_5010 database table.
 * 
 */
@Entity
@Table(name="EWV_AMBULANCE_INFO_5010")
public class EwvAmbulanceInfo5010 implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	private long guid;

	@Column(name="CERT_INDICATOR_1")
	private String certIndicator1;

	@Column(name="CERT_INDICATOR_2")
	private String certIndicator2;

	@Column(name="CERT_INDICATOR_3")
	private String certIndicator3;

	@Column(name="CONDITION_CODE_1_1")
	private String conditionCode1_1;

	@Column(name="CONDITION_CODE_1_2")
	private String conditionCode1_2;

	@Column(name="CONDITION_CODE_1_3")
	private String conditionCode1_3;

	@Column(name="CONDITION_CODE_1_4")
	private String conditionCode1_4;

	@Column(name="CONDITION_CODE_1_5")
	private String conditionCode1_5;

	@Column(name="CONDITION_CODE_2_1")
	private String conditionCode2_1;

	@Column(name="CONDITION_CODE_2_2")
	private String conditionCode2_2;

	@Column(name="CONDITION_CODE_2_3")
	private String conditionCode2_3;

	@Column(name="CONDITION_CODE_2_4")
	private String conditionCode2_4;

	@Column(name="CONDITION_CODE_2_5")
	private String conditionCode2_5;

	@Column(name="CONDITION_CODE_3_1")
	private String conditionCode3_1;

	@Column(name="CONDITION_CODE_3_2")
	private String conditionCode3_2;

	@Column(name="CONDITION_CODE_3_3")
	private String conditionCode3_3;

	@Column(name="CONDITION_CODE_3_4")
	private String conditionCode3_4;

	@Column(name="CONDITION_CODE_3_5")
	private String conditionCode3_5;

	@Column(name="DROPOFF_ADDRESS_LINE_1")
	private String dropoffAddressLine1;

	@Column(name="DROPOFF_ADDRESS_LINE_2")
	private String dropoffAddressLine2;

	@Column(name="DROPOFF_CITY")
	private String dropoffCity;

	@Column(name="DROPOFF_STATE")
	private String dropoffState;

	@Column(name="DROPOFF_ZIP")
	private String dropoffZip;

	@Column(name="PICKUP_ADDRESS_LINE_1")
	private String pickupAddressLine1;

	@Column(name="PICKUP_ADDRESS_LINE_2")
	private String pickupAddressLine2;

	@Column(name="PICKUP_CITY")
	private String pickupCity;

	@Column(name="PICKUP_STATE")
	private String pickupState;

	@Column(name="PICKUP_ZIP")
	private String pickupZip;

	@Column(name="ROUND_TRIP_PURPOSE")
	private String roundTripPurpose;

	@Column(name="STRETCHER_PURPOSE")
	private String stretcherPurpose;

	@Column(name="TRANSPORT_DISTANCE")
	private String transportDistance;

	@Column(name="TRANSPORT_REASON_CODE")
	private String transportReasonCode;

    // bi-directional many-to-one association to EwvClaim
    @ManyToOne
    @JoinColumn(name = "CLAIM_GUID")
    private EwvClaim ewvClaim;
    
    // bi-directional many-to-one association to EwvServiceLine
    @ManyToOne
    @JoinColumn(name = "SERVICE_LINE_GUID")
    private EwvServiceLine ewvServiceLine;
    
    public EwvAmbulanceInfo5010() {
    }

	public long getGuid() {
		return this.guid;
	}

	public void setGuid(long guid) {
		this.guid = guid;
	}

	public String getCertIndicator1() {
		return this.certIndicator1;
	}

	public void setCertIndicator1(String certIndicator1) {
		this.certIndicator1 = certIndicator1;
	}

	public String getCertIndicator2() {
		return this.certIndicator2;
	}

	public void setCertIndicator2(String certIndicator2) {
		this.certIndicator2 = certIndicator2;
	}

	public String getCertIndicator3() {
		return this.certIndicator3;
	}

	public void setCertIndicator3(String certIndicator3) {
		this.certIndicator3 = certIndicator3;
	}

	public String getConditionCode1_1() {
		return this.conditionCode1_1;
	}

	public void setConditionCode1_1(String conditionCode1_1) {
		this.conditionCode1_1 = conditionCode1_1;
	}

	public String getConditionCode1_2() {
		return this.conditionCode1_2;
	}

	public void setConditionCode1_2(String conditionCode1_2) {
		this.conditionCode1_2 = conditionCode1_2;
	}

	public String getConditionCode1_3() {
		return this.conditionCode1_3;
	}

	public void setConditionCode1_3(String conditionCode1_3) {
		this.conditionCode1_3 = conditionCode1_3;
	}

	public String getConditionCode1_4() {
		return this.conditionCode1_4;
	}

	public void setConditionCode1_4(String conditionCode1_4) {
		this.conditionCode1_4 = conditionCode1_4;
	}

	public String getConditionCode1_5() {
		return this.conditionCode1_5;
	}

	public void setConditionCode1_5(String conditionCode1_5) {
		this.conditionCode1_5 = conditionCode1_5;
	}

	public String getConditionCode2_1() {
		return this.conditionCode2_1;
	}

	public void setConditionCode2_1(String conditionCode2_1) {
		this.conditionCode2_1 = conditionCode2_1;
	}

	public String getConditionCode2_2() {
		return this.conditionCode2_2;
	}

	public void setConditionCode2_2(String conditionCode2_2) {
		this.conditionCode2_2 = conditionCode2_2;
	}

	public String getConditionCode2_3() {
		return this.conditionCode2_3;
	}

	public void setConditionCode2_3(String conditionCode2_3) {
		this.conditionCode2_3 = conditionCode2_3;
	}

	public String getConditionCode2_4() {
		return this.conditionCode2_4;
	}

	public void setConditionCode2_4(String conditionCode2_4) {
		this.conditionCode2_4 = conditionCode2_4;
	}

	public String getConditionCode2_5() {
		return this.conditionCode2_5;
	}

	public void setConditionCode2_5(String conditionCode2_5) {
		this.conditionCode2_5 = conditionCode2_5;
	}

	public String getConditionCode3_1() {
		return this.conditionCode3_1;
	}

	public void setConditionCode3_1(String conditionCode3_1) {
		this.conditionCode3_1 = conditionCode3_1;
	}

	public String getConditionCode3_2() {
		return this.conditionCode3_2;
	}

	public void setConditionCode3_2(String conditionCode3_2) {
		this.conditionCode3_2 = conditionCode3_2;
	}

	public String getConditionCode3_3() {
		return this.conditionCode3_3;
	}

	public void setConditionCode3_3(String conditionCode3_3) {
		this.conditionCode3_3 = conditionCode3_3;
	}

	public String getConditionCode3_4() {
		return this.conditionCode3_4;
	}

	public void setConditionCode3_4(String conditionCode3_4) {
		this.conditionCode3_4 = conditionCode3_4;
	}

	public String getConditionCode3_5() {
		return this.conditionCode3_5;
	}

	public void setConditionCode3_5(String conditionCode3_5) {
		this.conditionCode3_5 = conditionCode3_5;
	}

	public String getDropoffAddressLine1() {
		return this.dropoffAddressLine1;
	}

	public void setDropoffAddressLine1(String dropoffAddressLine1) {
		this.dropoffAddressLine1 = dropoffAddressLine1;
	}

	public String getDropoffAddressLine2() {
		return this.dropoffAddressLine2;
	}

	public void setDropoffAddressLine2(String dropoffAddressLine2) {
		this.dropoffAddressLine2 = dropoffAddressLine2;
	}

	public String getDropoffCity() {
		return this.dropoffCity;
	}

	public void setDropoffCity(String dropoffCity) {
		this.dropoffCity = dropoffCity;
	}

	public String getDropoffState() {
		return this.dropoffState;
	}

	public void setDropoffState(String dropoffState) {
		this.dropoffState = dropoffState;
	}

	public String getDropoffZip() {
		return this.dropoffZip;
	}

	public void setDropoffZip(String dropoffZip) {
		this.dropoffZip = dropoffZip;
	}

	public String getPickupAddressLine1() {
		return this.pickupAddressLine1;
	}

	public void setPickupAddressLine1(String pickupAddressLine1) {
		this.pickupAddressLine1 = pickupAddressLine1;
	}

	public String getPickupAddressLine2() {
		return this.pickupAddressLine2;
	}

	public void setPickupAddressLine2(String pickupAddressLine2) {
		this.pickupAddressLine2 = pickupAddressLine2;
	}

	public String getPickupCity() {
		return this.pickupCity;
	}

	public void setPickupCity(String pickupCity) {
		this.pickupCity = pickupCity;
	}

	public String getPickupState() {
		return this.pickupState;
	}

	public void setPickupState(String pickupState) {
		this.pickupState = pickupState;
	}

	public String getPickupZip() {
		return this.pickupZip;
	}

	public void setPickupZip(String pickupZip) {
		this.pickupZip = pickupZip;
	}

	public String getRoundTripPurpose() {
		return this.roundTripPurpose;
	}

	public void setRoundTripPurpose(String roundTripPurpose) {
		this.roundTripPurpose = roundTripPurpose;
	}

	public String getStretcherPurpose() {
		return this.stretcherPurpose;
	}

	public void setStretcherPurpose(String stretcherPurpose) {
		this.stretcherPurpose = stretcherPurpose;
	}

	public String getTransportDistance() {
		return this.transportDistance;
	}

	public void setTransportDistance(String transportDistance) {
		this.transportDistance = transportDistance;
	}

	public String getTransportReasonCode() {
		return this.transportReasonCode;
	}

	public void setTransportReasonCode(String transportReasonCode) {
		this.transportReasonCode = transportReasonCode;
	}

    public EwvClaim getEwvClaim()
    {
        return this.ewvClaim;
    }
    
    public void setEwvClaim(EwvClaim ewvClaim)
    {
        this.ewvClaim = ewvClaim;
    }
    
    public EwvServiceLine getEwvServiceLine()
    {
        return this.ewvServiceLine;
    }
    
    public void setEwvServiceLine(EwvServiceLine ewvServiceLine)
    {
        this.ewvServiceLine = ewvServiceLine;
    }
    
}