package gov.va.med.hac.edi.ewv2.beans.servicelines;

import gov.va.med.hac.edi.ewv2.actions.DTOBase;
import gov.va.med.hac.edi.ewv2.beans.claim.AmbulanceInfo;
import gov.va.med.hac.edi.ewv2.beans.ohi.linelevel.ServiceLineOhiAdjustment;
import gov.va.med.hac.edi.ewv2.utils.*;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;

public class ServiceLine extends DTOBase implements Serializable
{
    // begin and end were added for Phase II, when they should be separate
	private String                     beginDateOfService;
    private String                     endDateOfService;
    private String                     dateOfService;  // Not sure this is used
    private String                     revCode;
    private String                     procedureCode;
    private String                     ndcCode;
    private String                     modifiers;
    private String                     quantityOrType;
    
    // Ohi Stuff
    private String                     primaryPayerPaidAmount;
    private List<ServiceLineOhiAdjustment> primaryOhiServiceLineAdjustments;
    private String                     secondaryPayerPaidAmount;
    private List<ServiceLineOhiAdjustment> secondaryOhiServiceLineAdjustments;
    
    // Added quantity and type for Phase II, when they should be separate
    private String                     quantity;
    private String                     type;
    
    private String                     serviceTax;
    private String                     facilityTax;
    private String                     charge;
    
    private String                     lineNumber;
    private List<DrugLine>             listOfDrugLines;
    private List<ToothLine>            listOfTeeth;
    private List<MedicalEquipmentLine> listOfEquipment;
    private String                     dxDtPointers;
    private String                     salesTax;
    private List<Provider>             listOfProviderInfo;
    private String                     pos;
    
    // 5010 Stuff
    private AmbulanceInfo              serviceLineLevelAmbulanceInfo;

    public ServiceLine(String dateOfService,
    		           String beginDateOfService,
    		           String endDateOfService,
    		           String revCode,
    		           String procedureCode,
    		           String ndcCode,
    		           String modifiers,
    		           String quantityOrType,
    		           String quantity,
    		           String type,
                       String primaryPayerPaidAmount,
                       List<ServiceLineOhiAdjustment> primaryOhiServiceLineAdjustments,
                       String secondaryPayerPaidAmount,
                       List<ServiceLineOhiAdjustment> secondaryOhiServiceLineAdjustments,
    		           String serviceTax,
    		           String facilityTax,
    		           String charge,
    		           String lineNumber,
    		           List<DrugLine> listOfDrugLines,
    		           List<ToothLine> listOfTeeth,
    		           List<MedicalEquipmentLine> listOfEquipment,
    		           String dxDtPointers,
    		           String salesTax,
    		           List<Provider> listOfProviderInfo,
    		           String pos,
                       AmbulanceInfo serviceLineLevelAmbulanceInfo)
    {
        this.dateOfService = Ewv2Utils.formatAsDate(dateOfService);
        this.beginDateOfService = Ewv2Utils.formatAsDate(beginDateOfService);
        this.endDateOfService = Ewv2Utils.formatAsDate(endDateOfService);
        this.revCode = revCode;
        this.procedureCode = procedureCode;
        this.ndcCode = ndcCode;
        this.modifiers = modifiers;
        this.quantityOrType = quantityOrType;
        //this.quantity = Ewv2Utils.formatAsInteger(quantity);
        this.quantity = quantity;
        this.type = type;
        this.primaryPayerPaidAmount = Ewv2Utils.formatAsCurrency(primaryPayerPaidAmount);
        this.setPrimaryOhiServiceLineAdjustments(primaryOhiServiceLineAdjustments);
        this.secondaryPayerPaidAmount = Ewv2Utils.formatAsCurrency(secondaryPayerPaidAmount);
        this.setSecondaryOhiServiceLineAdjustments(secondaryOhiServiceLineAdjustments);
        this.serviceTax = Ewv2Utils.formatAsCurrency(serviceTax);
        this.facilityTax = Ewv2Utils.formatAsCurrency(facilityTax);
        this.charge = Ewv2Utils.formatAsCurrency(charge);
        this.lineNumber = Ewv2Utils.formatAsInteger(lineNumber);
        this.listOfDrugLines = listOfDrugLines;
        this.listOfTeeth = listOfTeeth;
        this.listOfEquipment = listOfEquipment;
        this.dxDtPointers = dxDtPointers;
        this.salesTax = Ewv2Utils.formatAsCurrency(salesTax);
        this.listOfProviderInfo = listOfProviderInfo;
        this.pos = pos;
        this.serviceLineLevelAmbulanceInfo = serviceLineLevelAmbulanceInfo;
    }
    
    public String getDateOfService()
    {
        return dateOfService;
    }
    
    public void setDateOfService(String dateOfService)
    {
        this.dateOfService = dateOfService;
    }
    
    public String getBeginDateOfService()
    {
        return beginDateOfService;
    }
    
    public void setBeginDateOfService(String beginDateOfService)
    {
        this.beginDateOfService = beginDateOfService;
    }
    
    public String getEndDateOfService()
    {
        return endDateOfService;
    }
    
    public void setEndDateOfService(String endDateOfService)
    {
        this.endDateOfService = endDateOfService;
    }
    
    public String getRevCode()
    {
        return revCode;
    }
    
    public void setRevCode(String revCode)
    {
        this.revCode = revCode;
    }
    
    public String getProcedureCode()
    {
        return procedureCode;
    }
    
    public void setProcedureCode(String procedureCode)
    {
        this.procedureCode = procedureCode;
    }
    
    public String getNdcCode()
    {
        return ndcCode;
    }
    
    public void setNdcCode(String ndcCode)
    {
        this.ndcCode = ndcCode;
    }
    
    public String getModifiers()
    {
        return modifiers;
    }
    
    public void setModifiers(String modifiers)
    {
        this.modifiers = modifiers;
    }
    
    public String getQuantityOrType()
    {
        return quantityOrType;
    }
    
    public void setQuantityOrType(String quantityOrType)
    {
        this.quantityOrType = quantityOrType;
    }
    
    public String getQuantity()
    {
        return quantity;
    }
    
    public void setQuantity(String quantity)
    {
        this.quantity = quantity;
    }
    
    public String getType()
    {
        return type;
    }
    
    public void setType(String type)
    {
        this.type = type;
    }
    
    public String getPrimaryPayerPaidAmount() {
      return primaryPayerPaidAmount;
    }

    public void setPrimaryPayerPaidAmount(String primaryPayerPaidAmount) {
      this.primaryPayerPaidAmount = primaryPayerPaidAmount;
    }

    public List<ServiceLineOhiAdjustment> getPrimaryOhiServiceLineAdjustments() {
      return primaryOhiServiceLineAdjustments;
    }

    public void setPrimaryOhiServiceLineAdjustments(
        List<ServiceLineOhiAdjustment> primaryOhiServiceLineAdjustments) {
      this.primaryOhiServiceLineAdjustments = primaryOhiServiceLineAdjustments;
    }

    public String getSecondaryPayerPaidAmount() {
      return secondaryPayerPaidAmount;
    }

    public void setSecondaryPayerPaidAmount(String secondaryPayerPaidAmount) {
      this.secondaryPayerPaidAmount = secondaryPayerPaidAmount;
    }

    public List<ServiceLineOhiAdjustment> getSecondaryOhiServiceLineAdjustments() {
      return secondaryOhiServiceLineAdjustments;
    }

    public void setSecondaryOhiServiceLineAdjustments(
        List<ServiceLineOhiAdjustment> secondaryOhiServiceLineAdjustments) {
      this.secondaryOhiServiceLineAdjustments = secondaryOhiServiceLineAdjustments;
    }

    public String getLineNumber()
    {
        return lineNumber;
    }
    
    public void setLineNumber(String lineNumber)
    {
        this.lineNumber = lineNumber;
    }
    
    public List<DrugLine> getListOfDrugLines()
    {
        return listOfDrugLines;
    }
    
    public void setListOfDrugLines(List<DrugLine> listOfDrugLines)
    {
        this.listOfDrugLines = listOfDrugLines;
    }
    
    public List<ToothLine> getListOfTeeth()
    {
        return listOfTeeth;
    }
    
    public void setListOfTeeth(List<ToothLine> listOfTeeth)
    {
        this.listOfTeeth = listOfTeeth;
    }
    
    public List<MedicalEquipmentLine> getListOfEquipment()
    {
        return listOfEquipment;
    }
    
    public void setListOfEquipment(List<MedicalEquipmentLine> listOfEquipment)
    {
        this.listOfEquipment = listOfEquipment;
    }
    
    public String getDxDtPointers()
    {
        return dxDtPointers;
    }
    
    public void setDxDtPointers(String dxDtPointers)
    {
        this.dxDtPointers = dxDtPointers;
    }
    
    public List<Provider> getListOfProviderInfo()
    {
        return listOfProviderInfo;
    }
    
    public void setListOfProviderInfo(List<Provider> listOfProviderInfo)
    {
        this.listOfProviderInfo = listOfProviderInfo;
    }
    
    public String getPos()
    {
        return pos;
    }
    
    public void setPos(String pos)
    {
        this.pos = pos;
    }
    
    public AmbulanceInfo getServiceLineLevelAmbulanceInfo() {
      return serviceLineLevelAmbulanceInfo;
    }

    public void setServiceLineLevelAmbulanceInfo(AmbulanceInfo serviceLineLevelAmbulanceInfo) {
      this.serviceLineLevelAmbulanceInfo = serviceLineLevelAmbulanceInfo;
    }

    public boolean getServiceLineLevelAmbulanceInfoShouldRender() {
      boolean returnVal = false;
      
      if (serviceLineLevelAmbulanceInfo != null && serviceLineLevelAmbulanceInfo.getShouldRender()) {
        returnVal = true;
      }
      
      return returnVal;
    }

    public String getServiceTax() {
      return serviceTax;
    }

    public void setServiceTax(String serviceTax) {
      this.serviceTax = serviceTax;
    }

    public String getFacilityTax() {
      return facilityTax;
    }

    public void setFacilityTax(String facilityTax) {
      this.facilityTax = facilityTax;
    }

    public String getSalesTax() {
      return salesTax;
    }

    public void setSalesTax(String salesTax) {
      this.salesTax = salesTax;
    }

    public String getCharge() {
      return charge;
    }

    public void setCharge(String charge) {
      this.charge = charge;
    }
    
//    // Used in sorting
//    public int compareTo(ServiceLine line)
//    {
//      // Constants
//      int equal = 0;
//      int mineLess = -1;
//      int mineGreater = 1;
//
//      // Value to return
//      int returnValue = equal;
//
//      try {
//        // First, try date
//        String myDateString = this.beginDateOfService;
//        String theirDateString = line.getBeginDateOfService();
//        
//        // If my date is present
//        if (myDateString != null && !myDateString.isEmpty()) {
//          // If their date is present
//          if (theirDateString != null && !theirDateString.isEmpty()) {
//            // Both dates present = parse and compare the two dates
//            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy");
//            Date myFromDate = formatter.parse(myDateString);
//            Date theirFromDate = formatter.parse(theirDateString);
//            returnValue = myFromDate.compareTo(theirFromDate);
//          } else {
//            // Only my date is present
//            returnValue = mineGreater;
//          }
//        } else {
//          if (theirDateString != null && !theirDateString.isEmpty()) {
//            // Only their date is present
//            returnValue = mineLess;
//          }
//        } // end of trying begin dates
//        
//        // Next, try procedure code
//        if (returnValue == equal) {
//          String myProcedureCode = this.procedureCode;
//          String theirProcedureCode = line.getProcedureCode();
//  
//          // If my procedure code is present
//          if (myProcedureCode != null && !myProcedureCode.isEmpty()) {
//            // If their date is present
//            if (theirProcedureCode != null && !theirProcedureCode.isEmpty()) {
//              // Both codes present = compare the two codes
//              returnValue = myProcedureCode.compareTo(theirProcedureCode);
//            } else {
//              // Only my code is present
//              returnValue = mineGreater;
//            }
//          } else {
//            if (theirProcedureCode != null && !theirProcedureCode.isEmpty()) {
//              // Only their code is present
//              returnValue = mineLess;
//            }
//          }
//        } // end of trying procedure codes
//         
//        // Finally, try line number
//        if (returnValue == equal) {
//          String myLineNumber = this.lineNumber;
//          String theirLineNumber = line.getLineNumber();
//  
//          // If my line number is present
//          if (myLineNumber != null && !myLineNumber.isEmpty()) {
//            // If their line number is present
//            if (theirLineNumber != null && !theirLineNumber.isEmpty()) {
//              // Both line numbers present = parse and compare the two line numbers
//              Integer mySequenceNumber = Integer.parseInt(myLineNumber);
//              Integer theirSequenceNumber = Integer.parseInt(theirLineNumber);
//              returnValue = mySequenceNumber.compareTo(theirSequenceNumber);
//            } else {
//              // Only my line number is present
//              returnValue = mineGreater;
//            }
//          } else {
//            if (theirLineNumber != null && !theirLineNumber.isEmpty()) {
//              // Only their line number is present
//              returnValue = mineLess;
//            }
//          } // end of trying begin dates
//        }
//      } catch (Exception e) {
//        // If these dates cannot be parsed for sorting, they could not be parsed for display
//        beginDateOfService = "Error";
//        returnValue = equal;
//      }
//
//      return returnValue;
//    }

}
