package gov.va.med.hac.edi.ewv2.beans.servicelines;

import gov.va.med.hac.edi.ewv2.utils.Ewv2Utils;

public class MedicalEquipmentLine
{
    private String lengthOfMedicalNecessity;
    private String frequency;
    private String rentalAmt;
    private String purchaseAmt;
    
    public MedicalEquipmentLine(String lengthOfMedicalNecessity, 
                                String frequency,
                                String rentalAmt,
                                String purchaseAmt)
    {
        this.lengthOfMedicalNecessity = lengthOfMedicalNecessity;
        this.frequency = frequency;
        this.rentalAmt = Ewv2Utils.formatAsCurrency(rentalAmt);
        this.purchaseAmt = Ewv2Utils.formatAsCurrency(purchaseAmt);
    }
    
    public String getLengthOfMedicalNecessity()
    {
        return lengthOfMedicalNecessity;
    }
    
    public void setLengthOfMedicalNecessity(String lengthOfMedicalNecessity)
    {
        this.lengthOfMedicalNecessity = lengthOfMedicalNecessity;
    }
    
    public String getFrequency()
    {
        return frequency;
    }
    
    public void setFrequency(String frequency)
    {
        this.frequency = frequency;
    }
    
    public String getRentalAmt()
    {
        return rentalAmt;
    }
    
    public void setRentalAmt(String rentalAmt)
    {
        this.rentalAmt = rentalAmt;
    }
    
    public String getPurchaseAmt()
    {
        return purchaseAmt;
    }
    
    public void setPurchaseAmt(String purchaseAmt)
    {
        this.purchaseAmt = purchaseAmt;
    }
    
    public boolean getShouldRentalAmountShow() {
      boolean returnVal = false;
      
      if (rentalAmt != null && rentalAmt.length() > 0) {
        returnVal = true;
      }
      
      return returnVal;
    }

    public boolean getShouldPurchaseAmountShow() {
      boolean returnVal = false;
      
      if (purchaseAmt != null && purchaseAmt.length() > 0) {
        returnVal = true;
      }
      
      return returnVal;
    }
}
