package gov.va.med.hac.edi.ewv2.beans.ohi.linelevel;

import gov.va.med.hac.edi.ewv2.beans.ohi.Adjustment;
import gov.va.med.hac.edi.ewv2.beans.ohi.AdjustmentType;
import gov.va.med.hac.edi.ewv2.utils.*;

import java.io.Serializable;

public class ServiceLineOhiAdjustment extends Adjustment implements Serializable
{
    private static final long serialVersionUID = 1L;

    //private String primaryPayerId;
    
    private String descriptionLong;
    private String descriptionShort;
    
    private String reasonCode ;
    private String quantity;
    
    private String  coAmount;
    private String  crAmount;
    private String  oaAmount;
    private String  piAmount;
    private String  prAmount;
    
    private AdjustmentType adjustmentType = null;

    public ServiceLineOhiAdjustment(String descriptionLong, 
                                    String descriptionShort,
                                    String reasonCode,
                                    String quantity, 
                                    String coAmount,
                                    String crAmount,
                                    String oaAmount,
                                    String piAmount,
                                    String prAmount)
    {
        //this.primaryPayerId = primaryPayerId;
        this.descriptionLong = descriptionLong;
        this.descriptionShort = descriptionShort;
        this.reasonCode = reasonCode;
        //this.quantity = Ewv2Utils.formatAsInteger(quantity);
        this.quantity = quantity;
        
        this.coAmount = Ewv2Utils.formatAsCurrency(coAmount);
        this.crAmount = Ewv2Utils.formatAsCurrency(crAmount);
        this.oaAmount = Ewv2Utils.formatAsCurrency(oaAmount);
        this.piAmount = Ewv2Utils.formatAsCurrency(piAmount);
        this.prAmount = Ewv2Utils.formatAsCurrency(prAmount);
        
        setShouldRender(Ewv2Utils.anyTrue((this.coAmount != null),
        								  (this.crAmount != null),
                                          (this.oaAmount != null),
                                          (this.piAmount != null),
                                          (this.prAmount != null)));
    }
    
//    /* (non-Javadoc)
//     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#getPrimaryPayerId()
//     */
//    public String getPrimaryPayerId()
//    {
//        return primaryPayerId;
//    }
//    
//    /* (non-Javadoc)
//     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#setPrimaryPayerId(java.lang.String)
//     */
//    public void setPrimaryPayerId(String primaryPayerId)
//    {
//        this.primaryPayerId = primaryPayerId;
//    }
//    
    /* (non-Javadoc)
     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#getDescriptionLong()
     */
    public String getDescriptionLong()
    {
        return descriptionLong;
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#setDescriptionLong(java.lang.String)
     */
    public void setDescriptionLong(String descriptionLong)
    {
        this.descriptionLong = descriptionLong;
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#getDescriptionShort()
     */
    public String getDescriptionShort()
    {
        return descriptionShort;
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#setDescriptionShort(java.lang.String)
     */
    public void setDescriptionShort(String descriptionShort)
    {
        this.descriptionShort = descriptionShort;
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#getReasonCode()
     */
    public String getReasonCode()
    {
        return reasonCode;
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#setReasonCode(java.lang.String)
     */
    public void setReasonCode(String reasonCode)
    {
        this.reasonCode = reasonCode;
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#getQuantity()
     */
    public String getQuantity()
    {
        return quantity;
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#setQuantity(java.lang.String)
     */
    public void setQuantity(String quantity)
    {
        this.quantity = quantity;
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#getAdjustmentType()
     */
    public AdjustmentType getAdjustmentType()
    {
        return adjustmentType;
    }

    /* (non-Javadoc)
     * @see gov.va.med.hac.edi.ewv2.beans.billinginvoice.ohiserviceline.X#setAdjustmentType(gov.va.med.hac.edi.ewv2.datatransfer.AdjustmentType)
     */
    public void setAdjustmentType(AdjustmentType adjustmentType)
    {
        this.adjustmentType = adjustmentType;
    }

    public String getCoAmount() {
      return coAmount;
    }

    public void setCoAmount(String coAmount) {
      this.coAmount = coAmount;
    }
    
    public String getCrAmount() {
        return crAmount;
      }

      public void setCrAmount(String crAmount) {
        this.crAmount = crAmount;
      }

    public String getOaAmount() {
      return oaAmount;
    }

    public void setOaAmount(String oaAmount) {
      this.oaAmount = oaAmount;
    }

    public String getPiAmount() {
      return piAmount;
    }

    public void setPiAmount(String piAmount) {
      this.piAmount = piAmount;
    }

    public String getPrAmount() {
      return prAmount;
    }

    public void setPrAmount(String prAmount) {
      this.prAmount = prAmount;
    }

}
