package gov.va.med.hac.edi.ewv2.beans.ohi.claimlevel;

import gov.va.med.hac.edi.ewv2.actions.DTOBase;
import gov.va.med.hac.edi.ewv2.utils.Ewv2Utils;

import java.io.Serializable;

public class ClaimOhiHeader extends DTOBase implements Serializable
{
    private String paymentSequenceIndicator;
    private String ohiGroupName;
    private String filingIndicator;
    private String benefitsAssignmentIndicator;
    private String insuranceType;
    private String claimAdjustmentDate;
    
    private String ohiPayerID;
    private String otherPayerName;
    
    public ClaimOhiHeader(String paymentSequenceIndicator,
                              String ohiGroupName, 
                              String filingIndicator,
                              String benefitsAssignmentIndicator,
                              String insuranceType,
                              String claimAdjustmentDate, 
                              String ohiPayerID,
                              String otherPayerName,
                              String ohiOne)
    {
        this.paymentSequenceIndicator = paymentSequenceIndicator;
        this.ohiGroupName = ohiGroupName;
        this.filingIndicator = filingIndicator;
        this.benefitsAssignmentIndicator = benefitsAssignmentIndicator;
        this.insuranceType = insuranceType;
        this.claimAdjustmentDate = Ewv2Utils.formatAsDate(claimAdjustmentDate);
        this.ohiPayerID = ohiPayerID;
        this.otherPayerName = otherPayerName;
    }
    
    public String getPaymentSequenceIndicator()
    {
        return paymentSequenceIndicator;
    }
    
    public void setPaymentSequenceIndicator(String paymentSequenceIndicator)
    {
        this.paymentSequenceIndicator = paymentSequenceIndicator;
    }
    
    public String getOhiGroupName()
    {
        return ohiGroupName;
    }
    
    public void setOhiGroupName(String ohiGroupName)
    {
        this.ohiGroupName = ohiGroupName;
    }
    
    public String getFilingIndicator()
    {
        return filingIndicator;
    }
    
    public void setFilingIndicator(String filingIndicator)
    {
        this.filingIndicator = filingIndicator;
    }
    
    public String getBenefitsAssignmentIndicator()
    {
        return benefitsAssignmentIndicator;
    }
    
    public void setBenefitsAssignmentIndicator(String benefitsAssignmentIndicator)
    {
        this.benefitsAssignmentIndicator = benefitsAssignmentIndicator;
    }
    
    public String getInsuranceType()
    {
        return insuranceType;
    }
    
    public void setInsuranceType(String insuranceType)
    {
        this.insuranceType = insuranceType;
    }
    
    public String getClaimAdjustmentDate()
    {
        return claimAdjustmentDate;
    }
    
    public void setClaimAdjustmentDate(String claimAdjustmentDate)
    {
        this.claimAdjustmentDate = claimAdjustmentDate;
    }
    
    public String getOhiPayerID()
    {
        return ohiPayerID;
    }
    
    public void setOhiPayerID(String ohiPayerID)
    {
        this.ohiPayerID = ohiPayerID;
    }
    
    public String getOtherPayerName()
    {
        return otherPayerName;
    }
    
    public void setOtherPayerName(String otherPayerName)
    {
        this.otherPayerName = otherPayerName;
    }
    
}
