package gov.va.med.hac.edi.ewv2.beans.ohi.claimlevel;


import gov.va.med.hac.edi.ewv2.beans.claim.CobAmountsBean;
import gov.va.med.hac.edi.ewv2.beans.ohi.Adjustment;
import gov.va.med.hac.edi.ewv2.utils.Ewv2Utils;

import java.io.Serializable;
import java.util.List;

public class ClaimOhiContainer implements Serializable, Comparable<ClaimOhiContainer>
{
    private ClaimOhiHeader                     claimOhiHeaderBean;
    private ClaimOhiAdjustmentsBean            claimOhiAdjustmentsBean;
    private CobAmountsBean                     cobAmountsBean;
    private MedicareInPatientAdjudicationBean  medicareInPatientAdjudicationBean;
    private MedicareOutPatientAdjudicationBean medicareOutPatientAdjudicationBean;
    
    public ClaimOhiContainer(ClaimOhiHeader claimOhiAdjustmentBean,
    		                ClaimOhiAdjustmentsBean claimOhiAdjustmentsBean,
    		                CobAmountsBean cobAmountsBean,
    		                MedicareInPatientAdjudicationBean medicareInPatientAdjudicationBean,
    		                MedicareOutPatientAdjudicationBean medicareOutPatientAdjudicationBean)
    {
        this.claimOhiHeaderBean = claimOhiAdjustmentBean;
        this.claimOhiAdjustmentsBean = claimOhiAdjustmentsBean;
        this.cobAmountsBean = cobAmountsBean;
        this.medicareInPatientAdjudicationBean = medicareInPatientAdjudicationBean;
        this.medicareOutPatientAdjudicationBean = medicareOutPatientAdjudicationBean;
    }
    
    public ClaimOhiHeader getClaimOhiHeaderBean()
    {
        return claimOhiHeaderBean;
    }
    
    public void setClaimOhiHeaderBean(ClaimOhiHeader claimOhiHeaderBean)
    {
        this.claimOhiHeaderBean = claimOhiHeaderBean;
    }
    
    public ClaimOhiAdjustmentsBean getClaimOhiAdjustmentsBean()
    {
        return claimOhiAdjustmentsBean;
    }
    
    public void setClaimOhiAdjustmentsBean(ClaimOhiAdjustmentsBean claimOhiAdjustmentsBean)
    {
        this.claimOhiAdjustmentsBean = claimOhiAdjustmentsBean;
    }
    
    public CobAmountsBean getCobAmountsBean()
    {
        return cobAmountsBean;
    }
    
    public void setCobAmountsBean(CobAmountsBean cobAmountsBean)
    {
        this.cobAmountsBean = cobAmountsBean;
    }
    
    public MedicareInPatientAdjudicationBean getMedicareInPatientAdjudicationBean()
    {
        return medicareInPatientAdjudicationBean;
    }
    
    public void setMedicareInPatientAdjudicationBean(MedicareInPatientAdjudicationBean medicareInPatientAdjudicationBean)
    {
        this.medicareInPatientAdjudicationBean = medicareInPatientAdjudicationBean;
    }
    
    public MedicareOutPatientAdjudicationBean getMedicareOutPatientAdjudicationBean()
    {
        return medicareOutPatientAdjudicationBean;
    }
    
    public void setMedicareOutPatientAdjudicationBean(MedicareOutPatientAdjudicationBean medicareOutPatientAdjudicationBean)
    {
        this.medicareOutPatientAdjudicationBean = medicareOutPatientAdjudicationBean;
    }
    
    public int compareTo(ClaimOhiContainer theirBean)
    {
        int equal = 0;
        int gt = 1;
        int lt = -1;
        int ret = equal;
        
        String mySequence = Ewv2Utils.defaultToSpace(getClaimOhiHeaderBean().getPaymentSequenceIndicator());
        String theirSequence = Ewv2Utils.defaultToSpace(theirBean.getClaimOhiHeaderBean().getPaymentSequenceIndicator());
  
        mySequence = mySequence.trim();
        theirSequence = theirSequence.trim();
        
        int mySequenceOrdinal = getOrdinal(mySequence);
        int theirSequenceOrdinal = getOrdinal(theirSequence);
        
        // correct sort is 
        //  payment sequence indicator P, 
        //  then others (like S, T, and so on...)

        if (mySequenceOrdinal == theirSequenceOrdinal)
        {
            ret = equal;
        }
        else if (mySequenceOrdinal < theirSequenceOrdinal)
        {
            ret = lt;
        }
        else if (mySequenceOrdinal > theirSequenceOrdinal)
        {
            ret = gt;
        }
        
        return ret;
    }

    private int getOrdinal(String sequence)
    {
        int ret = -1;
        
        if(sequence.equals("P"))
        {
           ret = 1;    
        }
        else if(sequence.equals("S"))
        {
           ret = 2;   
        }
        else if(sequence.equals("T"))
        {
           ret = 3; 
        }
        else
        {
           ret = 4;
        }
        
        return ret;
    }

    // Always render this section, even if there is no data there,
    //   to show the absence of an OHI Paid Amount.
    public boolean getShouldRenderClaimOhiAmountsSection()
    {
      return true;
    }

}
