package gov.va.med.hac.edi.ewv2.beans.ohi.claimlevel;

import gov.va.med.hac.edi.ewv2.beans.ohi.Adjustment;
import gov.va.med.hac.edi.ewv2.beans.ohi.AdjustmentType;
import gov.va.med.hac.edi.ewv2.utils.*;

import java.io.Serializable;

public class ClaimOhiAdjustment extends Adjustment implements Serializable
{
    private static final long serialVersionUID = 3822039878303611586L;
    private String reasonCode;
    private String descriptionLong;
    private String descriptionShort;
    private String quantity;
    private String  coAmount;
    private String  crAmount;
    private String  oaAmount;
    private String  piAmount;
    private String  prAmount;
    
    private AdjustmentType adjustmentType;
//    private String primaryPayerId;  
    
    public ClaimOhiAdjustment(String primaryPayerId,
    		                  String claimAdjustmentReasonCode,
    		                  String descriptionLong,
    		                  String descriptionShort,
    		                  String quantity,
    		                  String coAmount,
    		                  String crAmount,
    		                  String oaAmount,
    		                  String piAmount,
    		                  String prAmount)
    {
        this.reasonCode = claimAdjustmentReasonCode;
        this.descriptionLong = descriptionLong;
        this.descriptionShort = descriptionShort;
        //this.quantity = Ewv2Utils.formatAsInteger(quantity);
        this.quantity = quantity;
        this.coAmount = Ewv2Utils.formatAsCurrency(coAmount);
        this.crAmount = Ewv2Utils.formatAsCurrency(crAmount);
        this.oaAmount = Ewv2Utils.formatAsCurrency(oaAmount);
        this.piAmount = Ewv2Utils.formatAsCurrency(piAmount);
        this.prAmount = Ewv2Utils.formatAsCurrency(prAmount);
        
//        this.primaryPayerId = primaryPayerId;
    }
    
    public String getReasonCode()
    {
        return reasonCode;
    }
    
    public void setReasonCode(String claimAdjustmentReasonCode)
    {
        this.reasonCode = claimAdjustmentReasonCode;
    }
    
    public String getDescriptionLong()
    {
        return descriptionLong;
    }
    
    public void setDescriptionLong(String descriptionLong)
    {
        this.descriptionLong = descriptionLong;
    }
    
    public String getDescriptionShort()
    {
        return descriptionShort;
    }
    
    public void setDescriptionShort(String descriptionShort)
    {
        this.descriptionShort = descriptionShort;
    }
    
    public AdjustmentType getAdjustmentType()
    {
        return adjustmentType;
    }

    public void setAdjustmentType(AdjustmentType adjustmentType)
    {
        this.adjustmentType = adjustmentType;
    }

//    public String getPrimaryPayerId()
//    {
//        return primaryPayerId;
//    }
//
//    @Override
//    public void setPrimaryPayerId(String primaryPayerId)
//    {
//        this.primaryPayerId = primaryPayerId;
//    }

    public String getQuantity()
    {
        return quantity;
    }
    
    @Override
    public void setQuantity(String quantity)
    {
        this.quantity = quantity;
    }

    public String getCoAmount() {
      return coAmount;
    }

    public void setCoAmount(String coAmount) {
      this.coAmount = coAmount;
    }
    
    public String getCrAmount() {
      return crAmount;
    }

    public void setCrAmount(String crAmount) {
      this.crAmount = crAmount;
    }

    public String getOaAmount() {
      return oaAmount;
    }

    public void setOaAmount(String oaAmount) {
      this.oaAmount = oaAmount;
    }

    public String getPiAmount() {
      return piAmount;
    }

    public void setPiAmount(String piAmount) {
      this.piAmount = piAmount;
    }

    public String getPrAmount() {
      return prAmount;
    }

    public void setPrAmount(String prAmount) {
      this.prAmount = prAmount;
    }
    
}
