package gov.va.med.hac.edi.ewv2.beans.ohi;

import gov.va.med.hac.edi.ewv2.actions.DTOBase;

public abstract class Adjustment extends DTOBase implements Comparable<Adjustment>
{ 
//    public abstract String getPrimaryPayerId();
//    public abstract void setPrimaryPayerId(String primaryPayerId);
//    
    public abstract String getDescriptionLong();
    public abstract void setDescriptionLong(String descriptionLong);
    
    public abstract String getDescriptionShort();
    public abstract void setDescriptionShort(String descriptionShort);
    
    public abstract String getReasonCode();
    public abstract void setReasonCode(String reasonCode);
    
    public abstract String getQuantity();
    public abstract void setQuantity(String quantity);
    
    public abstract String getCoAmount();
    public abstract String getCrAmount();
    public abstract String getOaAmount();
    public abstract String getPiAmount();
    public abstract String getPrAmount();
    
    public abstract AdjustmentType getAdjustmentType();
    public abstract void setAdjustmentType(AdjustmentType adjustmentType);
    
    public int compareTo(Adjustment bean)
    {
       return AdjustmentType.compare(getAdjustmentType(), bean.getAdjustmentType());
    }

    // Phase Two Stuff
    public String getAdjustmentAmount() {
    	String returnValue;
    	AdjustmentType adjType = getAdjustmentType();
    	if (adjType != null) {
    		switch (adjType) {
	    		case CO : returnValue = getCoAmount(); break;
	    		case CR : returnValue = getCrAmount(); break;
	    		case OA : returnValue = getOaAmount(); break;
	    		case PI : returnValue = getPiAmount(); break;
	    		case PR : returnValue = getPrAmount(); break;
	    		default : returnValue = "";
	    	}
    	} else {
    		returnValue = "";
    	}
    	return returnValue;
    }
    
    public String getAdjustmentCode() {
    	StringBuilder sb = new StringBuilder();
    	
    	// Put on the type
    	AdjustmentType adjustmentType = getAdjustmentType();
    	if (adjustmentType != null) {
    		sb.append(adjustmentType.toString());
    	}
    
    	// Put on the reason
    	sb.append(getReasonCode());
      
      	return sb.toString();
    }
    

}
