package gov.va.med.hac.edi.ewv2.beans.demographics;


import gov.va.med.hac.edi.ewv2.utils.Ewv2Utils;

import java.io.Serializable;

public class PatientDataBean extends CommonDemographicData implements Serializable
{
    private static final long serialVersionUID = 9212340001239829834L;
    private String            patientName      = "   ";
    private String            patientIdNumber  = "  ";
    private String            dateOfBirth      = "  ";
    private String            dateOfDeath_5010      = "  ";
    private String            gender           = "   ";
    
    public PatientDataBean(String patientName,
                           String patientIdNumber,
                           String dateOfBirth,
                           String dateOfDeath_5010,
                           String gender,
                           String addressLineOne, 
                           String addressLineTwo,
                           String city,
                           String state,
                           String postalCode,
                           String country)
    {
        super(addressLineOne, addressLineTwo, city, state, postalCode, country);
        
        this.patientName = patientName;
        this.patientIdNumber = patientIdNumber;
        this.dateOfBirth = Ewv2Utils.formatAsDate(dateOfBirth, "MM/dd/yyyy");
        this.dateOfDeath_5010 = Ewv2Utils.formatAsDate(dateOfDeath_5010, "MM/dd/yyyy");
        this.gender = gender;
    }
    
    public PatientDataBean()
    {
        super(" ", " ", " ", " ", " ", " ");
    }
    
    public String getPatientName()
    {
        return patientName;
    }
    
    public String getPatientIdNumber()
    {
        return patientIdNumber;
    }
    
    public String getDateOfBirth()
    {
        return dateOfBirth;
    }
    
    public String getGender()
    {
        return gender;
    }

    public String getDateOfDeath_5010() {
      return dateOfDeath_5010;
    }

    public void setDateOfDeath_5010(String dateOfDeath_5010) {
      this.dateOfDeath_5010 = dateOfDeath_5010;
    }
    
}
