package gov.va.med.hac.edi.ewv2.beans.codes;

import gov.va.med.hac.edi.ewv2.actions.DTOBase;
import gov.va.med.hac.edi.ewv2.beans.claim.ClaimService;

import java.io.Serializable;
import java.util.List;

public class ProcedureCodesContainer extends DTOBase implements Serializable
{
    private String              principalProcedure;
    private String              dateOfPrincipalProcedure;
    
    // For Phase II, there is no need to use four columns
    private List<ProcedureCode> procedureCodes = null;

    public ProcedureCodesContainer(String principalProcedure,
    		                       String dateOfPrincipalProcedure,
    		                       List<ProcedureCode> procedureCodes)
    {
        this.principalProcedure = principalProcedure;
        this.dateOfPrincipalProcedure = dateOfPrincipalProcedure;
        this.procedureCodes = procedureCodes;
        
    }
    
    public String getPrincipalProcedure()
    {
        return principalProcedure;
    }
    
    public void setPrincipalProcedure(String principalProcedure)
    {
        this.principalProcedure = principalProcedure;
    }
    
    public String getDateOfPrincipalProcedure()
    {
        return dateOfPrincipalProcedure;
    }
    
    public void setDateOfPrincipalProcedure(String dateOfPrincipalProcedure)
    {
        this.dateOfPrincipalProcedure = dateOfPrincipalProcedure;
    }
    
    public List<ProcedureCode> getProcedureCodes()
    {
        return procedureCodes;
    }
    
    public void setProcedureCodes(List<ProcedureCode> procedureCodes)
    {
        this.procedureCodes = procedureCodes;
    }
    
    @Override
    public boolean getShouldRender()
    {
      boolean returnVal = false;
      
      if (principalProcedure != null && !principalProcedure.isEmpty()) {  
        returnVal = true;
      }
      
      if (procedureCodes != null && procedureCodes.size() > 0) {
        returnVal = true;
      }
      
      return returnVal;
    }
    
    public boolean getShouldOtherProcCodesRender()
    {
      boolean returnVal = false;
      
      if (procedureCodes != null && procedureCodes.size() > 1) {
        returnVal = true;
      }
      
      return returnVal;
    }
    
}
