package gov.va.med.hac.edi.ewv2.beans.codes;

import gov.va.med.hac.edi.ewv2.utils.Ewv2Utils;

import java.io.Serializable;

public class ProcedureCode extends CodeBase implements Serializable
{
    private static final long serialVersionUID = -5729926584399303196L;
    
    private String dateOfProcedure    = null;
    
    public ProcedureCode(Long procNumber, String procCode, String dateOfProcedure)
    {
        super(procNumber, procCode);
        this.dateOfProcedure = Ewv2Utils.formatAsDate(dateOfProcedure);
    }
    
    public String getDateOfProcedure()
    {
        return dateOfProcedure;
    }
    
    public void setDateOfProcedure(String dateOfProcedure)
    {
        this.dateOfProcedure = dateOfProcedure;
    }

}
