package gov.va.med.hac.edi.ewv2.beans.codes;

import gov.va.med.hac.edi.ewv2.actions.DTOBase;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DiagnosisCodesContainer extends DTOBase implements Serializable
{
    private static final long serialVersionUID             = -5504618821216378225L;
    private String            presentOnAdmissionNotesShort;
    private String            presentOnAdmissionNotesLong;
    private boolean           usePresentOnAdmissionModalPanel;
    
    private String            principalDiagnosisMasterCode;
    private String            principalDiagnosisPoa;
    private String            admittingDiagnosisMasterCode;
    private String            reasonForVisitMasterCode;
    private String            eCodeMasterCode;
    
    private List<DiagnosisCode>        diagnosisCodes;

    public DiagnosisCodesContainer(String presentOnAdmissionNotesShort,
    		                            String presentOnAdmissionNotesLong,
    		                            boolean usePresentOnAdmissionModalPanel,
    		                            String principalDiagnosisMasterCode,
    		                            String principalDiagnosisPoa,
    		                            String admittingDiagnosisMasterCode,
    		                            String reasonForVisitMasterCode,
    		                            String eCodeMasterCode,
    		                            List<DiagnosisCode> diagnosisCodes)
    {
        super();
        this.presentOnAdmissionNotesShort = presentOnAdmissionNotesShort;
        this.presentOnAdmissionNotesLong = presentOnAdmissionNotesLong;
        this.usePresentOnAdmissionModalPanel = usePresentOnAdmissionModalPanel;
        this.principalDiagnosisMasterCode = principalDiagnosisMasterCode;
        this.principalDiagnosisPoa = principalDiagnosisPoa;
        this.admittingDiagnosisMasterCode = admittingDiagnosisMasterCode;
        this.reasonForVisitMasterCode = reasonForVisitMasterCode;
        this.eCodeMasterCode = eCodeMasterCode;

        this.diagnosisCodes = diagnosisCodes;
    }
    
    public String getPresentOnAdmissionNotesShort()
    {
        return presentOnAdmissionNotesShort;
    }
    
    public void setPresentOnAdmissionNotesShort(String presentOnAdmissionNotesShort)
    {
        this.presentOnAdmissionNotesShort = presentOnAdmissionNotesShort;
    }
    
    public String getPresentOnAdmissionNotesLong()
    {
        return presentOnAdmissionNotesLong;
    }
    
    public void setPresentOnAdmissionNotesLong(String presentOnAdmissionNotesLong)
    {
        this.presentOnAdmissionNotesLong = presentOnAdmissionNotesLong;
    }
    
    public String getPrincipalDiagnosisMasterCode()
    {
        return principalDiagnosisMasterCode;
    }
    
    public void setPrincipalDiagnosisMasterCode(String principalDiagnosisMasterCode)
    {
        this.principalDiagnosisMasterCode = principalDiagnosisMasterCode;
    }
    
    public String getPrincipalDiagnosisPoa()
    {
        return principalDiagnosisPoa;
    }
    
    public void setPrincipalDiagnosisPoa(String principalDiagnosisPoa)
    {
        this.principalDiagnosisPoa = principalDiagnosisPoa;
    }
    
    public String getAdmittingDiagnosisMasterCode()
    {
        return admittingDiagnosisMasterCode;
    }
    
    public void setAdmittingDiagnosisMasterCode(String admittingDiagnosisMasterCode)
    {
        this.admittingDiagnosisMasterCode = admittingDiagnosisMasterCode;
    }
    
    public String getReasonForVisitMasterCode()
    {
        return reasonForVisitMasterCode;
    }
    
    public void setReasonForVisitMasterCode(String reasonForVisitMasterCode)
    {
        this.reasonForVisitMasterCode = reasonForVisitMasterCode;
    }
    
    public String geteCodeMasterCode()
    {
        return eCodeMasterCode;
    }
    
    public void seteCodeMasterCode(String eCodeMasterCode)
    {
        this.eCodeMasterCode = eCodeMasterCode;
    }
    
    public List<DiagnosisCode> getDiagnosisCodes()
    {
        return diagnosisCodes;
    }
    
    public void setDiagnosisCodes(List<DiagnosisCode> diagnosisCodes)
    {
        this.diagnosisCodes = diagnosisCodes;
    }

    public void setUsePresentOnAdmissionModalPanel(boolean usePresentOnAdmissionModalPanel) {
      this.usePresentOnAdmissionModalPanel = usePresentOnAdmissionModalPanel;
    }

    public boolean isUsePresentOnAdmissionModalPanel() {
      return usePresentOnAdmissionModalPanel;
    }
    
}
