package gov.va.med.hac.edi.ewv2.beans.codes;

import java.io.Serializable;
import java.util.List;

// Would like to use this to remove duplication among diagnosis codes, procedure codes,
//   and e codes, but would have to work out how to annotate the inheriting classes
public abstract class CodeBase implements Serializable, Comparable<CodeBase>
{
    protected static final long serialVersionUID = 1748134964415856234L;
    
    protected Long   sequenceNumber;
    protected String value;
    
    public CodeBase(Long sequenceNumber, String value)
    {
        this.sequenceNumber = sequenceNumber;
        this.value = value;
    }
    
    public String getSequenceNumberAsString()
    {
        String ret = null;
        
        if(sequenceNumber == null) {
            ret = " ";
        } else {
            ret = Long.toString(sequenceNumber) + ". ";    
        }
        
        return ret; 
    }
    
    public long getSequenceNumber()
    {
        return ((sequenceNumber == null) ? 0L : sequenceNumber);
    }
    
    public void setSequenceNumber(Long num)
    {
        this.sequenceNumber = num;
    }
    
    public String getValue()
    {
        return value;
    }
    
    public void setValue(String value)
    {
        this.value = value;
    }
    
    
    public int compareTo(CodeBase otherCode)
    {
        int equal = 0;
        int gt = 1;
        int lt = -1;
        int ret = equal;
        
        long mySequence = sequenceNumber;
        long theirSequence = otherCode.getSequenceNumber();
        
        if (mySequence == theirSequence)
        {
            ret = equal;
        }
        else if (mySequence > theirSequence)
        {
            ret = gt;
        }
        else if (mySequence < theirSequence)
        {
            ret = lt;
        }
        
        return ret;
    }

    public static <T extends CodeBase> List<T> renumber(List<T> codeList)
    {
        long sequenceNumber = 1L;
        
        for(CodeBase nextCode : codeList)
        {
          nextCode.setSequenceNumber(sequenceNumber++);
        }
        
        return codeList;
    }

}
