package gov.va.med.hac.edi.ewv2.beans.claim;

import gov.va.med.hac.edi.ewv2.persistence.base.*;
import gov.va.med.hac.edi.ewv2.utils.*;

import java.io.Serializable;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

@Name("Ewv2PatientHeaderInfo")
@Scope(ScopeType.SESSION)
public class PatientHeaderInfo implements Serializable
{
    private ClaimFormat claimFormat     = ClaimFormat.NONE;
    private ClaimType claimType         = ClaimType.NONE;
    private String medicareCrossOver = " ";
    private String patientName       = " ";
    private String billingNPI        = " ";
    private String memberID          = " ";
    
    private String tin               = " ";
    private String pdi               = " ";
    private String pcn               = " ";
    private String pcnShort;
    private boolean usePcnModalPanel;
    
    public PatientHeaderInfo(ClaimFormat claimFormat,
                             ClaimType claimType,
                             String medicareCrossOver, 
                             String patientName, 
                             String billingNPI,
                             String memberID, 
                             String tin, 
                             String pdi,
                             String pcn,
                             String pcnShort,
                             boolean usePcnModalPanel)
    {
        super();
        this.claimFormat = claimFormat;
        this.claimType = claimType;
        this.medicareCrossOver = medicareCrossOver;
        this.patientName = patientName;
        this.billingNPI = billingNPI;
        this.memberID = memberID;
        this.tin = tin;
        this.pdi = Ewv2Utils.formatPDIForOutput(pdi);
        this.pcn = pcn;
        this.pcnShort = pcnShort;
        this.usePcnModalPanel = usePcnModalPanel;
    }
    
    public PatientHeaderInfo()
    {
        
    }
    
    public ClaimFormat getClaimFormat()
    {
        return claimFormat;
    }
    
    public void setClaimFormat(ClaimFormat claimFormat)
    {
        this.claimFormat = claimFormat;
    }
    
    public ClaimType getClaimType()
    {
        return claimType;
    }
    
    public void setClaimType(ClaimType claimType)
    {
        this.claimType = claimType;
    }
    
    public String getMedicareCrossOver()
    {
        return medicareCrossOver;
    }
    
    public void setMedicareCrossOver(String medicareCrossOver)
    {
        this.medicareCrossOver = medicareCrossOver;
    }
    
    public String getPatientName()
    {
        return patientName;
    }
    
    public void setPatientName(String patientName)
    {
        this.patientName = patientName;
    }
    
    public String getBillingNPI()
    {
        return billingNPI;
    }
    
    public void setBillingNPI(String billingNPI)
    {
        this.billingNPI = billingNPI;
    }
    
    public String getMemberID()
    {
        return memberID;
    }
    
    public void setMemberID(String memberID)
    {
        this.memberID = memberID;
    }
    
    public String getTin()
    {
        return tin;
    }
    
    public void setTin(String tin)
    {
        this.tin = tin;
    }
    
    public String getPdi()
    {
        return pdi;
    }
    
    public void setPdi(String pdi)
    {
        this.pdi = pdi;
    }
    
    public String getPcn()
    {
        return pcn;
    }
    
    public void setPcn(String pcn)
    {
        this.pcn = pcn;
    }
    
    public String getPcnShort() {
      return pcnShort;
    }

    public void setPcnShort(String pcnShort) {
      this.pcnShort = pcnShort;
    }

    public boolean isUsePcnModalPanel() {
      return usePcnModalPanel;
    }

    public void setUsePcnModalPanel(boolean usePcnModalPanel) {
      this.usePcnModalPanel = usePcnModalPanel;
    }

    public String toString()
    {
        return pdi;
    }
    
}
