package gov.va.med.hac.edi.ewv2.beans.claim;

import gov.va.med.hac.edi.ewv2.persistence.base.*;

import java.io.Serializable;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;

@Name("Ewv2ClaimService")
@Scope(ScopeType.SESSION)
public class ClaimService implements Serializable
{
  @Logger
  protected Log log;
  
    @In("user")
    private String userName;
    
    private boolean isClaimFound;
    private ClaimType claimType       = ClaimType.NONE;
    private ClaimFormat claimFormat   = ClaimFormat.NONE;
    
    private boolean isInstitutional;
    private boolean isProfessional;
    private boolean isDental;
    
    private boolean is4010;
    private boolean is5010;
    
    private boolean isDebugOn;
    
    private String buildMessage = "---   Version: 3.0   ---   Build: 10/06/2011";
    
    public static String debug;

    public String lastError;
    
    public ClaimService() {
    }
    
    public ClaimService(ClaimType claimType,
                        ClaimFormat claimFormat) {
        this.claimType = claimType;
        this.claimFormat = claimFormat;
        this.isClaimFound = true;
    }
    
    public boolean getIsInstitutional() {
        isInstitutional = ((claimType == null) ? false : claimType.equals(ClaimType.INSTITUTIONAL));
        
        return isInstitutional;
    }
    
    public boolean getIsProfessional() {
        isProfessional = ((claimType == null) ? false : claimType.equals(ClaimType.PROFESSIONAL));
        
        return isProfessional;
    }
    
    public boolean getIsDental() {
        isDental = ((claimType == null) ? false : claimType.equals(ClaimType.DENTAL));
        
        return isDental;
    }
    
    public boolean getIs4010() {
        is4010 = ((claimFormat == null) ? false : claimFormat.equals(ClaimFormat.FORMAT4010));
        
        return is4010;
    }
    
    public boolean getIs5010()
    {
        is5010 = ((claimFormat == null) ? false : claimFormat.equals(ClaimFormat.FORMAT5010));
        
        return is5010;
    }
    
    public String getUserName()
    {
        return userName;
    }
    
    public void setUserName(String uname)
    {
        this.userName = uname;
    }
    
    public void setClaimType(ClaimType claimType)
    {
        this.claimType = claimType;
    }
    
    public void setClaimFormat(ClaimFormat claimFormat)
    {
        this.claimFormat = claimFormat;
    }
    
    public boolean getIsClaimFound() {
      return isClaimFound;
    }

    public void setIsClaimFound(boolean isClaimFound) {
      this.isClaimFound = isClaimFound;
    }

    public String getDebug() {
      return debug;
    }

    public void setDebug(String debug) {
      ClaimService.debug = debug;
    }

    public String getBuildMessage() {
      return buildMessage;
    }

    public void setBuildMessage(String buildMessage) {
      this.buildMessage = buildMessage;
    }

   public void initialize()
    {
      //log.info("Initializing a ClaimService.");
    }
    
   public String getLastError() {
     return lastError;
   }

   public void setLastError(String inLastError) {
     lastError = inLastError;
   }

   public boolean getDebugOn() {
     return isDebugOn;
   }

   public void setDebugOn(boolean isDebugOn) {
     this.isDebugOn = isDebugOn;
   }

}
