package gov.va.med.hac.edi.ewv2.beans.claim;

import gov.va.med.hac.edi.ewv2.beans.codes.*;
import gov.va.med.hac.edi.ewv2.beans.healthcareinfo.*;
import gov.va.med.hac.edi.ewv2.beans.ohi.linelevel.QuickViewServiceLineOhiOutputRow;
import gov.va.med.hac.edi.ewv2.beans.servicelines.ServiceLine;
import gov.va.med.hac.edi.ewv2.persistence.EwvClaim;

import java.io.Serializable;
import java.util.List;

public class ClaimContainer implements Serializable
{
    private static final long serialVersionUID = 6384062154193921978L;
    
    private String                          pdi;

    private BillingAndAdmissionInfo         billingAndAdmissionInfo;
    private DiagnosisCodesContainer         diagnosisCodesContainer;
    private ProcedureCodesContainer         procedureCodesContainer;
    private ECodesContainer                 e_CodesContainer;
    private List<ServiceLine>               serviceLineList;
    private List<HealthCareInformationLine> healthCareValueInformationLineList;
    private List<HealthCareInformationLine> healthCareConditionInformationLineList;
    private List<HealthCareInformationLine> healthCareOccurranceSpanInformationLineList;
    private List<HealthCareInformationLine> healthCareOccurranceInformationLineList;
    private List<HealthCareInformationLine> healthCareDRGInformationLineList;
    
    // 5010 Stuff
    private AmbulanceInfo                   claimLevelAmbulanceInfo;
    
    public ClaimContainer
             (BillingAndAdmissionInfo         billingAndAdmissionInfo,
    		  DiagnosisCodesContainer         diagnosisCodesContainer,
    		  ProcedureCodesContainer         procedureCodesContainer,
    		  ECodesContainer                 eCodesContainer,
    		  List<ServiceLine>               serviceLineList,
    		  List<HealthCareInformationLine> healthCareValueInformationBeanList,
    		  List<HealthCareInformationLine> healthCareConditionInformationBeanList,
    		  List<HealthCareInformationLine> healthCareOccurranceSpanInformationBeanList,
              List<HealthCareInformationLine> healthCareOccurranceInformationBeanList,
              List<HealthCareInformationLine> healthCareDRGInformationBeanList,
              AmbulanceInfo                   claimLevelAmbulanceInfo)
    {
        this.billingAndAdmissionInfo = billingAndAdmissionInfo;
        this.diagnosisCodesContainer = diagnosisCodesContainer;
        this.procedureCodesContainer = procedureCodesContainer;
        this.e_CodesContainer = eCodesContainer;
        this.serviceLineList = serviceLineList;
        this.healthCareValueInformationLineList = healthCareValueInformationBeanList;
        this.healthCareConditionInformationLineList = healthCareConditionInformationBeanList;
        this.healthCareOccurranceSpanInformationLineList = healthCareOccurranceSpanInformationBeanList;
        this.healthCareOccurranceInformationLineList = healthCareOccurranceInformationBeanList;
        this.healthCareDRGInformationLineList = healthCareDRGInformationBeanList;
        this.claimLevelAmbulanceInfo = claimLevelAmbulanceInfo;
        this.pdi = " ";
    }
    
    public ClaimContainer()
    {
        this.pdi = " ";
    }
    
    public ClaimContainer(EwvClaim claimBean)
    {
        this.pdi = " ";
    }
    
    public String getPdi()
    {
        return pdi;
    }
    
    public void setPdi(String pdi)
    {
        this.pdi = pdi;
    }
    
//    public BillingAndAdmissionInfo getBillingInvoiceDataBean()
//    {
//        return billingAndAdmissionInfo;
//    }
//    
//    public void setBillingInvoiceDataBean(BillingAndAdmissionInfo billingInvoiceDataBean)
//    {
//        this.billingAndAdmissionInfo = billingInvoiceDataBean;
//    }
//    
    public DiagnosisCodesContainer getHealthCareDiagnosisCodesBean()
    {
        return diagnosisCodesContainer;
    }
    
    public void setHealthCareDiagnosisCodesBean(DiagnosisCodesContainer healthCareDiagnosisCodesBean)
    {
        this.diagnosisCodesContainer = healthCareDiagnosisCodesBean;
    }
    
    public ProcedureCodesContainer getHealthCareProcedureCodesBean()
    {
        return procedureCodesContainer;
    }
    
    public void setHealthCareProcedureCodesBean(ProcedureCodesContainer healthCareProcedureCodesBean)
    {
        this.procedureCodesContainer = healthCareProcedureCodesBean;
    }
    
    public List<HealthCareInformationLine> getHealthCareValueInformationLineList()
    {
        return healthCareValueInformationLineList;
    }
    
    public void setHealthCareValueInformationLineList(List<HealthCareInformationLine> healthCareValueInformationLineList)
    {
        this.healthCareValueInformationLineList = healthCareValueInformationLineList;
    }
    
    public List<HealthCareInformationLine> getHealthCareConditionInformationLineList()
    {
        return healthCareConditionInformationLineList;
    }
    
    public void setHealthCareConditionInformationLineList(List<HealthCareInformationLine> healthCareConditionInformationLineList)
    {
        this.healthCareConditionInformationLineList = healthCareConditionInformationLineList;
    }
    
    public List<HealthCareInformationLine> getHealthCareOccurranceSpanInformationLineList()
    {
        return healthCareOccurranceSpanInformationLineList;
    }
    
    public void setHealthCareOccurranceSpanInformationLineList(List<HealthCareInformationLine> healthCareOccurranceSpanInformationLineList)
    {
        this.healthCareOccurranceSpanInformationLineList = healthCareOccurranceSpanInformationLineList;
    }
    
    public List<HealthCareInformationLine> getHealthCareOccurranceInformationLineList()
    {
        return healthCareOccurranceInformationLineList;
    }
    
    public void setHealthCareOccurranceInformationLineList(List<HealthCareInformationLine> healthCareOccurranceInformationLineList)
    {
        this.healthCareOccurranceInformationLineList = healthCareOccurranceInformationLineList;
    }

    public List<HealthCareInformationLine> getHealthCareDRGInformationLineList()
    {
        return healthCareDRGInformationLineList;
    }
    
    public void setHealthCareDRGInformationLineList(List<HealthCareInformationLine> healthCareDRGInformationLineList)
    {
        this.healthCareDRGInformationLineList = healthCareDRGInformationLineList;
    }

  public AmbulanceInfo getClaimLevelAmbulanceInfo() {
    return claimLevelAmbulanceInfo;
  }

  public void setClaimLevelAmbulanceInfo(AmbulanceInfo claimLevelAmbulanceInfo) {
    this.claimLevelAmbulanceInfo = claimLevelAmbulanceInfo;
  }

  public BillingAndAdmissionInfo getBillingAndAdmissionInfo() {
    return billingAndAdmissionInfo;
  }

  public void setBillingAndAdmissionInfo(BillingAndAdmissionInfo billingAndAdmissionInfo) {
    this.billingAndAdmissionInfo = billingAndAdmissionInfo;
  }

  public DiagnosisCodesContainer getDiagnosisCodesContainer() {
    return diagnosisCodesContainer;
  }

  public void setDiagnosisCodesContainer(DiagnosisCodesContainer diagnosisCodesContainer) {
    this.diagnosisCodesContainer = diagnosisCodesContainer;
  }

  public ProcedureCodesContainer getProcedureCodesContainer() {
    return procedureCodesContainer;
  }

  public void setProcedureCodesContainer(ProcedureCodesContainer procedureCodesContainer) {
    this.procedureCodesContainer = procedureCodesContainer;
  }

  public ECodesContainer getE_CodesContainer() {
    return e_CodesContainer;
  }

  public void setE_CodesContainer(ECodesContainer eCodesContainer) {
    this.e_CodesContainer = eCodesContainer;
  }

  public List<ServiceLine> getServiceLineList()
  {
      return serviceLineList;
  }
  
  public void setServiceLineList(List<ServiceLine> serviceLineList)
  {
      this.serviceLineList = serviceLineList;
  }
  
  public boolean getServiceLineLevelAmbulanceInfoShouldRender() {
    boolean returnVal = false;
    
    if (serviceLineList != null) {
      for (ServiceLine line : serviceLineList) {
        if (line.getServiceLineLevelAmbulanceInfoShouldRender()) {
          returnVal = true;
          break;
        }
      }
    }
    
    return returnVal;
  }

}
