package gov.va.med.hac.edi.ewv2.beans.claim;

import gov.va.med.hac.edi.ewv2.actions.DTOBase;
import gov.va.med.hac.edi.ewv2.utils.*;

import java.io.Serializable;

public class BillingAndAdmissionInfo extends DTOBase implements Serializable
{
    private static final long serialVersionUID                = -2874136098116906687L;
    private String            patientAccountNumber;
    private String            totalClaimCharges;

    private String            typeOfBillOrFrequency;
    private String            statementFromTo;
    private String            statementFromToEWV2;
    private String            previousPDIOrClaimNumber ;
    private String            patientPaidAmount;
    private String            patientSignature;
    private String            patientStatus;
    
    private String            admissionType;
    private String            providerAcceptsAssignment;
    private String            admissionSource;
    private String            assignmentOfBenefits;
    private String            admissionDateOrHour;
    private String			  medicareIcn;
    
    // Admission date and hour added for Phase II, where they must be separate
    private String            admissionDate;
    private String            admissionHour;
    
    private String            dischargeDateOrHour;
    private String            accidentDate;
    private String            accidentIndicator;

    private String            priorAuthorizationReferralLong;
    private String            priorAuthorizationReferralShort;
    private boolean           usePriorAuthorizationModalPanel;
    
    private String            frequency;
    
    // Added for Phase II
    private String            admittingDiagnosis;
    private String            reasonForVisit;
    private String            eeCode;
    private String            poaNotesShort;
    private String            poaNotesLong;
    private boolean           usePoaNotesModalPanel;

    // Added for 5010
    private String            reasonForVisit2_5010;
    private String            reasonForVisit3_5010;
    private String            referralLong_5010;
    private String            referralShort_5010;
    private boolean           useReferralModalPanel_5010;
    
    public BillingAndAdmissionInfo(String patientAccountNumber,
    		                      String totalClaimCharges,
    		                      String typeOfBillOrFrequency,
    		                      String statementFromTo,
    		                      String statementFromToEWV2,
    		                      String previousPDIOrClaimNumber,
    		                      String patientPaidAmount,
    		                      String patientSignature,
    		                      String patientStatus,
    		                      String priorAuthorizationReferralLong,
    		                      String admissionType,
    		                      String providerAcceptsAssignment,
    		                      String admissionSource,
    		                      String assignmentOfBenefits,
    		                      String admissionDateOrHour,
    		                      String admissionDate,
    		                      String admissionHour,
    		                      String dischargeDateOrHour,
    		                      String medicareIcn,
    		                      String accidentDate,
    		                      String accidentIndicator,
                                  String priorAuthorizationReferralShort,
                                  boolean usePriorAuthorizationModalPanel,
                                  String frequency,
                                  
                                  // Added for Phase II
                                  String admittingDiagnosis,
                                  String reasonForVisit,
                                  String eeCode,
                                  String poaNotesShort,
                                  String poaNotesLong,
                                  boolean usePoaNotesModalPanel,
                                  
                                  // Added for 5010
                                  String reasonForVisit2_5010,
                                  String reasonForVisit3_5010,
                                  String referralLong_5010,
                                  String referralShort_5010,
                                  boolean useReferralModalPanel_5010)
    {
        this.patientAccountNumber = patientAccountNumber;
        this.totalClaimCharges = Ewv2Utils.formatAsCurrency(totalClaimCharges);
        this.typeOfBillOrFrequency = typeOfBillOrFrequency;
        this.statementFromTo = statementFromTo;
        this.statementFromToEWV2 = statementFromToEWV2;
        this.previousPDIOrClaimNumber = previousPDIOrClaimNumber;
        this.patientPaidAmount = Ewv2Utils.formatAsCurrency(patientPaidAmount);
        this.patientSignature = patientSignature;
        this.patientStatus = patientStatus;
        this.priorAuthorizationReferralLong = priorAuthorizationReferralLong;
        this.priorAuthorizationReferralShort = priorAuthorizationReferralShort;
        this.usePriorAuthorizationModalPanel = usePriorAuthorizationModalPanel;
        this.admissionType = admissionType;
        this.providerAcceptsAssignment = providerAcceptsAssignment;
        this.admissionSource = admissionSource;
        this.assignmentOfBenefits = assignmentOfBenefits;
        this.admissionDateOrHour = admissionDateOrHour;
        this.admissionDate = Ewv2Utils.formatAsDate(admissionDate);
        this.admissionHour = admissionHour;
        if (dischargeDateOrHour != null && dischargeDateOrHour.length() > 5) {
          this.dischargeDateOrHour = Ewv2Utils.formatAsDate(dischargeDateOrHour);
        } else {
          this.dischargeDateOrHour = dischargeDateOrHour;
        }
        this.medicareIcn = medicareIcn;
        this.accidentDate = Ewv2Utils.formatAsDate(accidentDate);
        this.accidentIndicator = accidentIndicator;
        this.frequency = frequency;
        
        // New for Phase II
        this.admittingDiagnosis = admittingDiagnosis;
        this.reasonForVisit = reasonForVisit;
        this.eeCode = eeCode;
        this.poaNotesShort = poaNotesShort;
        this.poaNotesLong = poaNotesLong;
        this.setUsePoaNotesModalPanel(usePoaNotesModalPanel);

        // New for 5010
        this.reasonForVisit2_5010 = reasonForVisit2_5010;
        this.reasonForVisit3_5010 = reasonForVisit3_5010;
        this.referralLong_5010 = referralLong_5010;
        this.referralShort_5010 = referralShort_5010;
        this.useReferralModalPanel_5010 = useReferralModalPanel_5010;
    }
    
    public String getFrequency()
    {
        return frequency;
    }

    public void setFrequency(String frequency)
    {
        this.frequency = frequency;
    }
    
    public String getPatientAccountNumber()
    {
        return patientAccountNumber;
    }
    
    public void setPatientAccountNumber(String patientAccountNumber)
    {
        this.patientAccountNumber = patientAccountNumber;
    }
    
    public String getTotalClaimCharges()
    {
        return totalClaimCharges;
    }
    
    public void setTotalClaimCharges(String totalClaimCharges)
    {
        this.totalClaimCharges = totalClaimCharges;
    }
    
//    public Float getTotalClaimChargesAsNumber()
//    {
//        return totalClaimChargesAsNumber;
//    }
//    
//    public void setTotalClaimChargesAsNumber(Float totalClaimChargesAsNumber)
//    {
//        this.totalClaimChargesAsNumber = totalClaimChargesAsNumber;
//    }
//    
    public String getTypeOfBillOrFrequency()
    {
        return typeOfBillOrFrequency;
    }
    
    public void setTypeOfBillOrFrequency(String typeOfBillOrFrequency)
    {
        this.typeOfBillOrFrequency = typeOfBillOrFrequency;
    }
    
    public String getStatementFromTo()
    {
        return statementFromTo;
    }
    
    public void setStatementFromTo(String statementFromTo)
    {
        this.statementFromTo = statementFromTo;
    }
    
    public String getStatementFromToEWV2()
    {
        return statementFromToEWV2;
    }
    
    public void setStatementFromToEWV2(String statementFromToEWV2)
    {
        this.statementFromToEWV2 = statementFromToEWV2;
    }
    
    public String getPreviousPDIOrClaimNumber()
    {
        return previousPDIOrClaimNumber;
    }
    
    public void setPreviousPDIOrClaimNumber(String previousPDIOrClaimNumber)
    {
        this.previousPDIOrClaimNumber = previousPDIOrClaimNumber;
    }
    
    public String getPatientPaidAmount()
    {
        return patientPaidAmount;
    }
    
    public void setPatientPaidAmount(String patientPaidAmount)
    {
        this.patientPaidAmount = patientPaidAmount;
    }
    
    public String getPatientSignature()
    {
        return patientSignature;
    }
    
    public void setPatientSignature(String patientSignature)
    {
        this.patientSignature = patientSignature;
    }
    
    public String getPatientStatus()
    {
        return patientStatus;
    }
    
    public void setPatientStatus(String patientStatus)
    {
        this.patientStatus = patientStatus;
    }
    
    public String getPriorAuthorizationReferralLong()
    {
        return priorAuthorizationReferralLong;
    }
    
    public void setPriorAuthorizationReferralLong(String priorAuthorizationReferralLong)
    {
        this.priorAuthorizationReferralLong = priorAuthorizationReferralLong;
    }
    
    public String getAdmissionType()
    {
        return admissionType;
    }
    
    public void setAdmissionType(String admissionType)
    {
        this.admissionType = admissionType;
    }
    
    public String getProviderAcceptsAssignment()
    {
        return providerAcceptsAssignment;
    }
    
    public void setProviderAcceptsAssignment(String providerAcceptsAssignment)
    {
        this.providerAcceptsAssignment = providerAcceptsAssignment;
    }
    
    public String getAdmissionSource()
    {
        return admissionSource;
    }
    
    public void setAdmissionSource(String admissionSource)
    {
        this.admissionSource = admissionSource;
    }
    
    public String getAssignmentOfBenefits()
    {
        return assignmentOfBenefits;
    }
    
    public void setAssignmentOfBenefits(String assignmentOfBenefits)
    {
        this.assignmentOfBenefits = assignmentOfBenefits;
    }
    
    public String getAdmissionDateOrHour()
    {
        return admissionDateOrHour;
    }
    
    public void setAdmissionDateOrHour(String admissionDateOrHour)
    {
        this.admissionDateOrHour = admissionDateOrHour;
    }
    
	public String getAdmissionDate()
    {
        return admissionDate;
    }
    
    public void setAdmissionDate(String admissionDate)
    {
        this.admissionDate = admissionDate;
    }
    
    public String getAdmissionHour()
    {
        return admissionHour;
    }
    
    public void setAdmissionHour(String admissionHour)
    {
        this.admissionHour = admissionHour;
    }
    
    public String getDischargeDateOrHour()
    {
        return dischargeDateOrHour;
    }
    
    public void setDischargeDateOrHour(String dischargeDateOrHour)
    {
        this.dischargeDateOrHour = dischargeDateOrHour;
    }
    
    public String getMedicareIcn() {
		return medicareIcn;
	}

	public void setMedicareIcn(String medicareIcn) {
		this.medicareIcn = medicareIcn;
	}

    public String getAccidentDate()
    {
        return accidentDate;
    }
    
    public void setAccidentDate(String accidentDate)
    {
        this.accidentDate = accidentDate;
    }
    
    public String getAccidentIndicator()
    {
        return accidentIndicator;
    }
    
    public void setAccidentIndicator(String accidentIndicator)
    {
        this.accidentIndicator = accidentIndicator;
    }
    
    public String getPriorAuthorizationReferralShort()
    {
        return priorAuthorizationReferralShort;
    }
    
    public void setPriorAuthorizationReferralShort(String priorAuthorizationReferralShort)
    {
        this.priorAuthorizationReferralShort = priorAuthorizationReferralShort;
    }
    
    public String getAdmittingDiagnosis()
    {
        return admittingDiagnosis;
    }
    
    public void setAdmittingDiagnosis(String admittingDiagnosis)
    {
        this.admittingDiagnosis = admittingDiagnosis;
    }
    
    public String getReasonForVisit()
    {
        return reasonForVisit;
    }
    
    public void setReasonForVisit(String reasonForVisit)
    {
        this.reasonForVisit = reasonForVisit;
    }
    
    public String getReasonForVisit2_5010() {
      return reasonForVisit2_5010;
    }

    public void setReasonForVisit2_5010(String reasonForVisit2) {
      this.reasonForVisit2_5010 = reasonForVisit2;
    }

    public String getReasonForVisit3_5010() {
      return reasonForVisit3_5010;
    }

    public void setReasonForVisit3_5010(String reasonForVisit3) {
      this.reasonForVisit3_5010 = reasonForVisit3;
    }

    public String getEeCode()
    {
        return eeCode;
    }
    
    public void setEeCode(String eCode)
    {
        this.eeCode = eCode;
    }
    
    public String getPoaNotesShort()
    {
        return poaNotesShort;
    }
    
    public void setPoaNotesShort(String poaNotesShort)
    {
        this.poaNotesShort = poaNotesShort;
    }
    
    public String getPoaNotesLong()
    {
        return poaNotesLong;
    }
    
    public void setPoaNotesLong(String poaNotesLong)
    {
        this.poaNotesLong = poaNotesLong;
    }

    public void setUsePoaNotesModalPanel(boolean usePoaNotesModalPanel) {
      this.usePoaNotesModalPanel = usePoaNotesModalPanel;
    }

    public boolean isUsePoaNotesModalPanel() {
      return usePoaNotesModalPanel;
    }

    public void setUsePriorAuthorizationModalPanel(boolean usePriorAuthorizationModalPanel) {
      this.usePriorAuthorizationModalPanel = usePriorAuthorizationModalPanel;
    }

    public boolean isUsePriorAuthorizationModalPanel() {
      return usePriorAuthorizationModalPanel;
    }
    
    // Concatenate the three reasons for visit together
    public String getAllReasonsForVisit() {
      String returnValue = "";
      
      if (reasonForVisit != null && reasonForVisit.length() > 0) {
        returnValue = reasonForVisit;
      }
      
      if (reasonForVisit2_5010 != null && reasonForVisit2_5010.length() > 0) {
        // Only add a comma if something was already there
        if (returnValue.length() > 0) {
          returnValue += ", ";
        }
        returnValue += reasonForVisit2_5010;
      }
      
      if (reasonForVisit3_5010 != null && reasonForVisit3_5010.length() > 0) {
        // Only add a comma if something was already there
        if (returnValue.length() > 0) {
          returnValue += ", ";
        }
        returnValue += reasonForVisit3_5010;
      }
      
      return returnValue;
    }

    public String getReferralLong_5010() {
      return referralLong_5010;
    }

    public void setReferralLong_5010(String referralLong_5010) {
      this.referralLong_5010 = referralLong_5010;
    }

    public String getReferralShort_5010() {
      return referralShort_5010;
    }

    public void setReferralShort_5010(String referralShort_5010) {
      this.referralShort_5010 = referralShort_5010;
    }

    public boolean isUseReferralModalPanel_5010() {
      return useReferralModalPanel_5010;
    }

    public void setUseReferralModalPanel_5010(boolean useReferralModalPanel_5010) {
      this.useReferralModalPanel_5010 = useReferralModalPanel_5010;
    }
    
    public boolean getShouldMiscPanelRender() {
      boolean empty = true;
      
      if (providerAcceptsAssignment != null && !providerAcceptsAssignment.isEmpty()) {
        empty = false;
      }
      if (patientPaidAmount != null && !patientPaidAmount.isEmpty()) {
        empty = false;
      }
      
      return !empty;
    }

    
    

}
