package gov.va.med.hac.edi.ewv2.beans.claim;

import gov.va.med.hac.edi.ewv2.actions.DTOBase;
import gov.va.med.hac.edi.ewv2.utils.Ewv2Utils;

import java.io.*;
import java.util.*;

public class AmbulanceInfo extends DTOBase implements Serializable
{
    private static final long serialVersionUID                    = 3615915360571663352L;
    
    private String pickupAddressLine1;
    private String pickupAddressLine2;
    private String pickupCity;
    private String pickupState;
    private String pickupZip;
    
    private String dropoffAddressLine1;
    private String dropoffAddressLine2;
    private String dropoffCity;
    private String dropoffState;
    private String dropoffZip;

    private String transportReasonCode;
    private String transportDistance;
    
    private String roundTripPurpose;
    private String roundTripPurposeShort;
    private boolean useRoundTripPurposeModalPanel;
    
    private String stretcherPurpose;
    private String stretcherPurposeShort;
    private boolean useStretcherPurposeModalPanel;
    
    private List<AmbulanceCert> certs;
    
    public AmbulanceInfo() {}
    
    public AmbulanceInfo(String pickupAddressLine1, 
                         String pickupAddressLine2, 
                         String pickupCity, 
                         String pickupState, 
                         String pickupZip, 
                         String dropoffAddressLine1, 
                         String dropoffAddressLine2, 
                         String dropoffCity, 
                         String dropoffState, 
                         String dropoffZip, 
                         String transportReasonCode, 
                         String transportDistance, 
                         String roundTripPurpose, 
                         String roundTripPurposeShort, 
                         boolean useRoundTripPurposeModalPanel, 
                         String stretcherPurpose, 
                         String stretcherPurposeShort, 
                         boolean useStretcherPurposeModalPanel, 
                         List<AmbulanceCert> certs)
    {
        this.pickupAddressLine1 = pickupAddressLine1;
        this.pickupAddressLine2 = pickupAddressLine2;
        this.pickupCity = pickupCity;
        this.pickupState = pickupState;
        this.pickupZip = pickupZip;
        this.dropoffAddressLine1 = dropoffAddressLine1;
        this.dropoffAddressLine2 = dropoffAddressLine2;
        this.dropoffCity = dropoffCity;
        this.dropoffState = dropoffState;
        this.dropoffZip = dropoffZip;
        this.transportReasonCode = transportReasonCode;
        this.transportDistance = Ewv2Utils.formatAsInteger(transportDistance);
        this.roundTripPurpose = roundTripPurpose;
        this.roundTripPurposeShort = roundTripPurposeShort;
        this.useRoundTripPurposeModalPanel = useRoundTripPurposeModalPanel;
        this.stretcherPurpose = stretcherPurpose;
        this.stretcherPurposeShort = stretcherPurposeShort;
        this.useStretcherPurposeModalPanel = useStretcherPurposeModalPanel;
        this.certs = certs;
    }

    public String getPickupAddressLine1() {
      return pickupAddressLine1;
    }

    public void setPickupAddressLine1(String pickupAddressLine1) {
      this.pickupAddressLine1 = pickupAddressLine1;
    }

    public String getPickupAddressLine2() {
      return pickupAddressLine2;
    }

    public void setPickupAddressLine2(String pickupAddressLine2) {
      this.pickupAddressLine2 = pickupAddressLine2;
    }

    public String getPickupCity() {
      return pickupCity;
    }

    public void setPickupCity(String pickupCity) {
      this.pickupCity = pickupCity;
    }

    public String getPickupState() {
      return pickupState;
    }

    public void setPickupState(String pickupState) {
      this.pickupState = pickupState;
    }

    public String getPickupZip() {
      return pickupZip;
    }

    public void setPickupZip(String pickupZip) {
      this.pickupZip = pickupZip;
    }

    public String getDropoffAddressLine1() {
      return dropoffAddressLine1;
    }

    public void setDropoffAddressLine1(String dropoffAddressLine1) {
      this.dropoffAddressLine1 = dropoffAddressLine1;
    }

    public String getDropoffAddressLine2() {
      return dropoffAddressLine2;
    }

    public void setDropoffAddressLine2(String dropoffAddressLine2) {
      this.dropoffAddressLine2 = dropoffAddressLine2;
    }

    public String getDropoffCity() {
      return dropoffCity;
    }

    public void setDropoffCity(String dropoffCity) {
      this.dropoffCity = dropoffCity;
    }

    public String getDropoffState() {
      return dropoffState;
    }

    public void setDropoffState(String dropoffState) {
      this.dropoffState = dropoffState;
    }

    public String getDropoffZip() {
      return dropoffZip;
    }

    public void setDropoffZip(String dropoffZip) {
      this.dropoffZip = dropoffZip;
    }

    public String getTransportReasonCode() {
      return transportReasonCode;
    }

    public void setTransportReasonCode(String transportReasonCode) {
      this.transportReasonCode = transportReasonCode;
    }

    public String getTransportDistance() {
      return transportDistance;
    }

    public void setTransportDistance(String transportDistance) {
      this.transportDistance = transportDistance;
    }

    public String getRoundTripPurpose() {
      return roundTripPurpose;
    }

    public void setRoundTripPurpose(String roundTripPurpose) {
      this.roundTripPurpose = roundTripPurpose;
    }

    public String getStretcherPurpose() {
      return stretcherPurpose;
    }

    public void setStretcherPurpose(String stretcherPurpose) {
      this.stretcherPurpose = stretcherPurpose;
    }

    public String getRoundTripPurposeShort() {
      return roundTripPurposeShort;
    }

    public void setRoundTripPurposeShort(String roundTripPurposeShort) {
      this.roundTripPurposeShort = roundTripPurposeShort;
    }

    public boolean isUseRoundTripPurposeModalPanel() {
      return useRoundTripPurposeModalPanel;
    }

    public void setUseRoundTripPurposeModalPanel(boolean useRoundTripPurposeModalPanel) {
      this.useRoundTripPurposeModalPanel = useRoundTripPurposeModalPanel;
    }

    public String getStretcherPurposeShort() {
      return stretcherPurposeShort;
    }

    public void setStretcherPurposeShort(String stretcherPurposeShort) {
      this.stretcherPurposeShort = stretcherPurposeShort;
    }

    public boolean isUseStretcherPurposeModalPanel() {
      return useStretcherPurposeModalPanel;
    }

    public void setUseStretcherPurposeModalPanel(boolean useStretcherPurposeModalPanel) {
      this.useStretcherPurposeModalPanel = useStretcherPurposeModalPanel;
    }

    public List<AmbulanceCert> getCerts() {
      return certs;
    }

    public void setCerts(List<AmbulanceCert> certs) {
      this.certs = certs;
    }
    
    public boolean getShouldLocationsRender()
    {
       boolean nonEmpty = Ewv2Utils.okToRender(getPickupAddressLine1(),
                                               getPickupAddressLine2(),
                                               getPickupCity(),
                                               getPickupState(),
                                               getPickupZip(),
                                               getDropoffAddressLine1(),
                                               getDropoffAddressLine2(),
                                               getDropoffCity(),
                                               getDropoffState(),
                                               getDropoffZip());
      
      return nonEmpty;
    }
    
    public boolean getShouldTransportRender()
    {
       boolean nonEmpty = Ewv2Utils.okToRender(getTransportReasonCode(),
                                               getRoundTripPurpose(),
                                               getTransportDistance(),
                                               getStretcherPurpose());
      
      return nonEmpty;
    }
    
    public boolean getShouldCertsRender()
    {
      boolean nonEmpty = false;
      
      if (certs != null) {
        for (AmbulanceCert cert : certs) {
          if (cert != null && !cert.isEmpty()) {
            nonEmpty = true;
          }
        }
      }
      
      return nonEmpty;
    }
    
    public boolean getShouldRender()
    {
      return getShouldLocationsRender() ||
             getShouldTransportRender() ||
             getShouldCertsRender();
    }
    
}
