package gov.va.med.hac.edi.ewv2.beans.claim;

import gov.va.med.hac.edi.ewv2.actions.DTOBase;

import java.io.*;
import java.util.*;

public class AmbulanceCert extends DTOBase implements Serializable
{
    private static final long serialVersionUID = 3612915360571663352L;
    
    private String certIndicator;
    
    private String conditionCodes;
    
    public AmbulanceCert() {}
    
    public AmbulanceCert(String certIndicator, 
                         String conditionCodes)
    {
        this.certIndicator = certIndicator;
        this.conditionCodes = conditionCodes;
    }


    public String getConditionCodes() {
      return conditionCodes;
    }

    public void setConditionCodes(String conditionCodes) {
      this.conditionCodes = conditionCodes;
    }
    
    public String getCertIndicator() {
      return certIndicator;
    }

    public void setCertIndicator(String certIndicator) {
      this.certIndicator = certIndicator;
    }

    public boolean isEmpty() {
      boolean returnVal = true;
      
      if (certIndicator != null && !certIndicator.isEmpty()) {
        returnVal = false;
      }
      
        if (conditionCodes != null && !conditionCodes.isEmpty()) {
          returnVal = false;
        }
      
      return returnVal;
    }

    public boolean getShouldRender()
    {
      boolean empty = true;
      
      if (certIndicator != null && !certIndicator.isEmpty()) {
        empty = false;
      }
      if (conditionCodes != null && !conditionCodes.isEmpty()) {
        empty = false;
      }
      
      return !empty;
    }
    
}
