package gov.va.med.hac.edi.ewv2.actions;

import gov.va.med.hac.edi.ewv2.beans.demographics.*;
import gov.va.med.hac.edi.ewv2.beans.claim.*;
import gov.va.med.hac.edi.ewv2.persistence.*;
import gov.va.med.hac.edi.ewv2.persistence.base.*;
import gov.va.med.hac.edi.ewv2.utils.Ewv2Utils;
import gov.va.med.hac.edi.ewv2.exceptions.*;

public class DemographicsDataBinder extends DTOBase
{

  public CommonDemographicsContainer getCommonDemographics(EwvClaim claimBean)
  throws NonUniqueRecordsException
  {
    PatientDataBean patientDataBean = getPatientInfo(claimBean);
    ServiceLocationBean serviceLocationDataBean = getServiceLocationInfo(claimBean);
    VendorDataBean vendorDataBean = getVendorInfo(claimBean);
    
    return new CommonDemographicsContainer( patientDataBean,
                                            serviceLocationDataBean,
                                            vendorDataBean);
  }
  
  public static PatientDataBean getPatientInfo(EwvClaim claimBean)
  {
      PatientDataBean ret = new PatientDataBean(claimBean.getPatientName(), 
                                                claimBean.getPatientIdNumber(), 
                                                claimBean.getPatientDob(),
                                                claimBean.getPatientDateOfDeath_5010(),
                                                claimBean.getPatientGender(), 
                                                claimBean.getPatientAddressLine1(),
                                                claimBean.getPatientAddressLine2(), 
                                                claimBean.getPatientCity(), 
                                                claimBean.getPatientState(), 
                                                claimBean.getPatientPostalCode(), 
                                                claimBean.getPatientCountry());
      
      return ret;
  }

  public static ServiceLocationBean getServiceLocationInfo(EwvClaim claimBean)
  {
      ServiceLocationBean ret
        = new ServiceLocationBean(claimBean.getServiceVendorName(), 
                                  claimBean.getServiceVendorTaxIdNum(), 
                                  claimBean.getServiceVendorNpi(),
                                  claimBean.getBillingVendorTaxonomyCode(),
                                  claimBean.getServiceVendorAddressLine1(),
                                  claimBean.getServiceVendorAddressLine2(), 
                                  claimBean.getServiceVendorCity(), 
                                  claimBean.getServiceVendorState(), 
                                  claimBean.getServiceVendorPostalCode(),
                                  claimBean.getServiceVendorCountry());
      
      return ret;
  }

  public static PatientHeaderInfo populatePatientHeaderInfo(EwvClaim claim) {
    String medicareCrossOver = claim.getMedicareCrossover();
    String patientName = claim.getPatientName();
    String billingNPI = claim.getBillingVendorNpi();
    String memberID = claim.getMemberId();
    String tin = claim.getBillingVendorTaxIdNum();
    String pdi = claim.getPdi();
    String pcn = claim.getInvoicePatientAccountNum();
    String pcnShort = Ewv2Utils.shorten(pcn, 20);
    boolean usePcnModalPanel = pcnShort.endsWith("...");

    ClaimFormat claimFormat = determineClaimFormat(claim);
    ClaimType claimType = determineClaimType(claim);

    return new PatientHeaderInfo(claimFormat,
                                 claimType,
                                 medicareCrossOver,
                                 patientName,
                                 billingNPI,
                                 memberID,
                                 tin, 
                                 pdi,
                                 pcn,
                                 pcnShort,
                                 usePcnModalPanel);
  }

  public static VendorDataBean getVendorInfo(EwvClaim claimBean)
  {
      VendorDataBean ret
         = new VendorDataBean(claimBean.getBillingVendorName(), 
                              claimBean.getBillingVendorTaxIdNum(),
                              claimBean.getBillingVendorNpi(), 
                              claimBean.getBillingVendorTaxonomyCode(),
                              claimBean.getBillingVendorAddressLine1(), 
                              claimBean.getBillingVendorAddressLine2(), 
                              claimBean.getBillingVendorCity(),
                              claimBean.getBillingVendorState(), 
                              claimBean.getBillingVendorPostalCode(),
                              claimBean.getBillingVendorCountry());
      
      return ret;
  }
  
  public static ClaimFormat determineClaimFormat(EwvClaim claim) {
    String claimTypeString = claim.getClaimType();
    return ClaimFormat.typeOf(claimTypeString);
  }

  public static ClaimType determineClaimType(EwvClaim claim) {
    String claimTypeString = claim.getClaimType();
    return ClaimType.typeOf(claimTypeString);
  }

}
