package gov.va.med.hac.edi.ewv2.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import gov.va.med.hac.edi.ewv2.beans.claim.AmbulanceCert;
import gov.va.med.hac.edi.ewv2.beans.ohi.linelevel.ServiceLineOhiAdjustment;
import gov.va.med.hac.edi.ewv2.beans.ohi.*;
import gov.va.med.hac.edi.ewv2.beans.servicelines.*;
import gov.va.med.hac.edi.ewv2.persistence.*;
import gov.va.med.hac.edi.ewv2.utils.Ewv2Utils;

public class DTOBase
{
    private boolean shouldRender = true;
    
    public boolean getShouldRender()
    {
        return shouldRender;
    }
    
    public void setShouldRender(boolean shouldRender)
    {
        this.shouldRender = shouldRender;
    }
    

    protected List<Provider> createProviders(Set<EwvSlProvider> EwvSlProvider)
    {
        List<Provider> providers = new ArrayList<Provider>();
        
        for (EwvSlProvider prov : EwvSlProvider)
        {
            String name = Ewv2Utils.defaultToSpace(prov.getProviderLname()) 
                          + ", " 
                          + Ewv2Utils.defaultToSpace(prov.getProviderFname())
                          + " "
                          + Ewv2Utils.defaultToSpace(prov.getProviderMname());
            String postalcode_5010 = prov.getPostalCode_5010();
            
            Provider provider = new Provider(ProviderType.typeOf(prov.getProviderType()),
                                             prov.getProviderId(),
                                             prov.getProviderNpi_5010(),
                                             name,
                                             postalcode_5010, 
                                             prov.getTaxonomyCode());
            
            providers.add(provider);
        }
        
        return providers;
    }
    
    protected List<ToothLine> createToothLines(Set<EwvSvcLineTeeth> toothLineSet)
    {
        List<ToothLine> returnTeeth = new ArrayList<ToothLine>();
        
        for (EwvSvcLineTeeth tooth : toothLineSet)
        {
            String toothNumber = tooth.getToothNumber();
            String surface1 = tooth.getSurface1();
            String surface2 = tooth.getSurface2();
            String surface3 = tooth.getSurface3();
            String surface4 = tooth.getSurface4();
            String surface5 = tooth.getSurface5();
            
            ToothLine teethLine = new ToothLine(toothNumber,
                                                surface1,
                                                surface2, 
                                                surface3,
                                                surface4,
                                                surface5);
            
            returnTeeth.add(teethLine);
        }
        
        // order the teeth list by tooth number
        Collections.sort(returnTeeth);
        
        return returnTeeth;
    }
    
    protected String getQuantityOrType(EwvServiceLine line)
    {
        return Ewv2Utils.defaultToSpace(line.getQuantity()) + " " + Ewv2Utils.defaultToSpace(line.getType());
    }
    
    protected List<DrugLine> createDrugLines(Set<EwvServiceLinesDrug> listOfDrugLines)
    {
        List<DrugLine> drugs = new ArrayList<DrugLine>();
        
        for (EwvServiceLinesDrug drug : listOfDrugLines)
        {
            String drugRx = drug.getDrugRx();
            String drugRxNdcCode = drug.getDrugRxNdcCode();
            String drugRxQuantityPlusType = Ewv2Utils.defaultToSpace(drug.getDrugRxQuantity())
                                          + " " + Ewv2Utils.defaultToSpace(drug.getDrugRxType());
            String drugRxQuantity = drug.getDrugRxQuantity();
            String drugRxType = drug.getDrugRxType();
            String drugRxCharge = drug.getDrugRxCharge();
            String drugCategoryString = drug.getDrugRxCategory_5010();
            DrugCategory_5010 drugCategory_5010 = DrugCategory_5010.typeOf(drugCategoryString);
            
            DrugLine line = new DrugLine(drugRx,
            		                     drugRxNdcCode,
            		                     drugRxQuantityPlusType,
            		                     drugRxQuantity,
            		                     drugRxType,
            		                     drugRxCharge,
            		                     drugCategory_5010);
            
            drugs.add(line);
        }
        
        return drugs;
    }


    protected List<AmbulanceCert> populateAmbulanceCert(List<AmbulanceCert> certs,
                                                        String certIndicator,
                                                        String... conditionCodesArray)
    {
      // Start up a new cert
      AmbulanceCert newCert = new AmbulanceCert();
      
      // Fill its fields
      newCert.setCertIndicator(certIndicator);
      String conditionCodes = Ewv2Utils.concatWithSeparator(", ", conditionCodesArray);
      newCert.setConditionCodes(conditionCodes);
      
      // If there is any data there, add it to the incoming
      if (!newCert.isEmpty()) {
        certs.add(newCert);
      }
      
      return certs;
    }
    
    protected OhiType determineOhiType(EwvServiceLineOhi lineOhi, EwvClaim claim) {
      OhiType returnType = null;
      
      // 4010 Phase 1 - get the first adjudication for this ohi, and use it to determine type
      EwvServiceLineOhiAdjtmt firstAdjustment = null;
      //OhiType payerType = null;
      
      Set<EwvServiceLineOhiAdjtmt> adjustments = lineOhi.getEwvServiceLineOhiAdjtmts();
      if (adjustments != null && !adjustments.isEmpty()) {
        for (EwvServiceLineOhiAdjtmt nextAdjustment : adjustments) {
          firstAdjustment = nextAdjustment;
          break;
        }
        String payerId = firstAdjustment.getPrimaryPayerId();
        returnType = determinePayerType(payerId, claim);
      
      }

      // 4010 Phase 2 - just use the field on the service line ohi
      if (returnType == null) {
        returnType = OhiType.PRIMARY;
      }
      
      return returnType;
    }

    protected OhiType determinePayerType(String payerId, EwvClaim claim) {
      OhiType returnType = null;
      
      // Go through the claim OHIs, looking for the payerId sent in
      Set<EwvClaimOhi> claimOhis = claim.getEwvClaimOhis();
      for (EwvClaimOhi claimOhi : claimOhis) {
        String thisPayerId = claimOhi.getOhiPayerId();
        if (thisPayerId != null && thisPayerId.equals(payerId)) {
          String typeIndicator = claimOhi.getPaymentSequenceIndicator();
          if (typeIndicator != null) {
            returnType = OhiType.typeOf(typeIndicator);
          }
        }
      }
      
      return returnType;
    }

    protected List<ServiceLineOhiAdjustment> populateServiceLineAdjustments
      (Set<EwvServiceLineOhiAdjtmt> adjustments) {
      List<ServiceLineOhiAdjustment> returnAdjustments = new ArrayList<ServiceLineOhiAdjustment>();
      
      // Go through the adjustments
      for (EwvServiceLineOhiAdjtmt nextAdjustment : adjustments) {
        ServiceLineOhiAdjustment newAdjustment = createOhiServiceLineAdjustment(nextAdjustment);
        if (newAdjustment != null) {
          returnAdjustments.add(newAdjustment);
        }
      }
      
      return returnAdjustments;
    }

    private ServiceLineOhiAdjustment createOhiServiceLineAdjustment(EwvServiceLineOhiAdjtmt adj)
    {
        //String payerId = adj.getPrimaryPayerId();
        String descriptionLong = adj.getDescription();
        String descriptionShort = Ewv2Utils.shorten(descriptionLong,15);
        String reasonCode = adj.getSvcLineAdjustmtReasonCode();
        String quantity = adj.getQuantity();
        String coAmount = adj.getCoAmt();
        String crAmount = adj.getCrAmt();
        String oaAmount = adj.getOaAmt();
        String piAmount = adj.getPiAmt();
        String prAmount = adj.getPrAmt();
        
        ServiceLineOhiAdjustment ret
          = new ServiceLineOhiAdjustment(descriptionLong, 
                                         descriptionShort,
                                         reasonCode,
                                         quantity, 
                                         coAmount,
                                         crAmount, 
                                         oaAmount,
                                         piAmount,
                                         prAmount);
        
        if (coAmount != null)
        {
            ret.setAdjustmentType(AdjustmentType.CO);
        }
        else if (crAmount != null)
        {
            ret.setAdjustmentType(AdjustmentType.CR);
        }
        else if (oaAmount != null)
        {
            ret.setAdjustmentType(AdjustmentType.OA);
        }
        else if (piAmount != null)
        {
            ret.setAdjustmentType(AdjustmentType.PI);
        }
        else if (prAmount != null)
        {
            ret.setAdjustmentType(AdjustmentType.PR);
        }
        
        return ret;
    }
    
}
