package gov.va.med.hac.edi.ewv2.actions;

import gov.va.med.hac.edi.ewv2.beans.reference.ReferenceBean;
import gov.va.med.hac.edi.ewv2.exceptions.*;
import gov.va.med.hac.edi.ewv2.persistence.EwvReference;

import java.io.*;
import java.util.ArrayList;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.persistence.*;

import org.jboss.seam.*;
import org.jboss.seam.annotations.*;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.log.Log;

@Name("Ewv2AllReferenceAction")
@Scope(ScopeType.CONVERSATION)
public class AllReferenceAction implements Serializable {
	  private static final long serialVersionUID = 5215329070049375734L;

	  @In(create = true)
	  protected EntityManager entityManager;
	  
	  @Logger
	  protected Log log;

	  @Out("Ewv2ReferenceBean")
	  private ReferenceBean referenceBeanList;
	  
	  @Restrict("#{s:hasRole('ewvUser')}")
	  public void getAllReference() throws ActionErrorException, NonUniqueRecordsException {
	    try {
	    	ArrayList<EwvReference> referenceList = getReferenceRecord();
	      
	    	String errorMessage = "Unable to find Reference.";

		      
	    	if (referenceList != null) {
	    		log.info("Found References: ");
	    	} else {
		        // No Reference was found
				FacesContext.getCurrentInstance().addMessage("ewvApplication", new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, ""));
		    }
	    } catch (Throwable e) {
		      log.info("DEBUG: Caught a throwable: " + e);
	    }
	
	  }

	  protected ArrayList<EwvReference> getReferenceRecord() throws ActionErrorException, NonUniqueRecordsException
	  {
	      ArrayList<EwvReference> retList = null;
	      String queryString ="select reference from EwvReference as reference where reference.active = :active";
	      try {
	          Query query = entityManager.createQuery(queryString);
	          query.setParameter("active", 1);
	          retList = (ArrayList<EwvReference>) query.getResultList();
	      } catch (Throwable t) {
	          if (t instanceof javax.persistence.NoResultException)
	          {
	              log.info("cannot get record for Reference: ");
	          }
	          else if(t instanceof javax.persistence.NonUniqueResultException)
	          {
	              log.error("more than 1 Reference exists for active: ");
	              
	              // this means that there are crap claim records in DB
	              throw new NonUniqueRecordsException("more than 1 Reference exists for active: ");
	          }
	          else
	          {
	              // log exception and route user to error page
	              handleException();
	          }
	      }
	      
	      return retList;
	  }

	private void handleException() {
		// TODO Auto-generated method stub
		
	}
	  
}

