// Might be able to mark these panels with similar ids, and find them rather than list them
function collapsePanels() {
	collapsePanel('DetailPatientInfoPanel');
	collapsePanel('DetailVendorInfoPanel');
	collapsePanel('BillingMiscPanel');
	collapsePanel('DetailBillingInfoPanel');
	collapsePanel('DetailHealthCareProcedureCodesPanel');
	collapsePanel('DetailServiceLinesPanel');
	collapsePanel('DetailServiceLineOhiAdjustmentsPanel');
	collapsePanel('DetailOhiPayersPanel');
	collapsePanel('ValueDetailHealthCareInfoPanel');
	collapsePanel('OccurrenceSpanDetailHealthCareInfoPanel');
	collapsePanel('OccurrenceInfoDetailHealthCareInfoPanel');
	collapsePanel('ConditionInfoDetailHealthCareInfoPanel');
	collapsePanel('DetailClaimLevelAmbulanceInfoPanel');
	collapsePanel('DetailServiceLineLevelAmbulanceInfoPanel');

    focusGivenInput("DetailPatientInfoHeaderInput");
}

function expandPanels() {
	expandPanel('DetailPatientInfoPanel');
	expandPanel('DetailVendorInfoPanel');
	expandPanel('BillingMiscPanel');
	expandPanel('DetailBillingInfoPanel');
	expandPanel('DetailHealthCareProcedureCodesPanel');
	expandPanel('DetailServiceLinesPanel');
	expandPanel('DetailServiceLineOhiAdjustmentsPanel');
	expandPanel('DetailOhiPayersPanel');
	expandPanel('ValueDetailHealthCareInfoPanel');
	expandPanel('OccurrenceSpanDetailHealthCareInfoPanel');
	expandPanel('OccurrenceInfoDetailHealthCareInfoPanel');
	expandPanel('ConditionInfoDetailHealthCareInfoPanel');
	expandPanel('DetailClaimLevelAmbulanceInfoPanel');
	expandPanel('DetailServiceLineLevelAmbulanceInfoPanel');

    focusGivenInput("DetailPatientInfoHeaderInput");
}

function collapsePanel(panelId) {
  var element = SimpleTogglePanelManager.panels.get(panelId);
	if (element && element.status == "true") {
	    SimpleTogglePanelManager.toggleOnClient('onclick', panelId);
	}
}

function expandPanel(panelId) {
  var element = SimpleTogglePanelManager.panels.get(panelId);
  if (element) {
    if (element.status == "false") {
	  SimpleTogglePanelManager.toggleOnClient('onclick', panelId);
    }
  }
}

function gotoQuickviewFromAccelerator() {
	RichFaces.switchTab('quickViewTabPanelContainer', 'quickViewTab','quickViewTab');
    enterQuickview();
    focusGivenInput("QuickViewPatientInfoHeaderInput");
}

function enterQuickview() {
	hideControl("toolbarTable:0:expandButton");
	hideControl("toolbarTable:0:collapseButton");
}

function gotoDetailViewFromAccelerator() {
	RichFaces.switchTab('quickViewTabPanelContainer', 'detailTab', 'detailTab');
    enterDetailView();
    focusGivenInput("DetailPatientInfoHeaderInput");
}

function enterDetailView() {
    showControl("toolbarTable:0:expandButton");
    showControl("toolbarTable:0:collapseButton");
}

/*function gotoAdminViewFromAccelerator() {
	RichFaces.switchTab('quickViewTabPanelContainer', 'adminTab', 'adminTab');
    enterAdminView();
    focusGivenInput("QuickViewPatientInfoHeaderInput");
}

function enterAdminView() {
	hideControl("toolbarTable:0:expandButton");
	hideControl("toolbarTable:0:collapseButton");
}
*/
function gotoDetailOhi() {
	gotoDetailViewFromAccelerator();
	collapsePanels();
	expandPanel('DetailOhiPayersPanel');
	expandPanel('DetailServiceLineOhiAdjustmentsPanel');
    focusGivenInput("DetailOhiPayersHeaderInput");
}