function form_OnLoad() {
    if (Xrm.Page.ui.getFormType() != 1) { loadLOBForm(); }
    Xrm.Page.getAttribute("vhacrm_previousfacilityid").setValue(Xrm.Page.getAttribute("vhacrm_facilityid").getValue());

    loadWebParts();
}

function form_OnSave(context) {
    preventAutoSave(context);
}

function type_OnChange(context) {
    Xrm.Page.getAttribute("vhacrm_areaintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_resolutionintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setRequiredLevel("none");
}

function area_OnChange(context) {
    Xrm.Page.data.entity.save();
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setRequiredLevel("none");
    N52.Clientside.ExecuteFormulas(context, 'Q5i');
}

function resolution_OnChange() {
    Xrm.Page.data.entity.save();
}

function caseNoteTemplate_OnChange(context) {
    N52.Clientside.ExecuteFormulas(context, 'lSq');
    Xrm.Page.data.entity.save();
}

function facility_OnChange() {
    Xrm.Utility.confirmDialog("Are you sure you want to change the facility?",
        function () {
            Xrm.Page.getAttribute("vhacrm_previousfacilityid").setValue(Xrm.Page.getAttribute("vhacrm_facilityid").getValue());
            Xrm.Page.data.entity.save();
        },

        function () {
            Xrm.Page.getAttribute("vhacrm_facilityid").setValue(Xrm.Page.getAttribute("vhacrm_previousfacilityid").getValue());
            return false;
        }
    );
}

function loadWebParts() {
    unattendedSearchFromRelatedRecord("customerid", loadCaseNotes, loadAssociations, loadESRWebParts);
}

function loadCaseNotes(icn) {
    displayWebPart(icn, 'IFRAME_cprscasenotes', 'hdr_notes_endpoint');
}

function loadAssociations(icn) {
    displayWebPart(icn, 'IFRAME_associations', 'esr_associations_endpoint');
}

function loadESRWebParts(icn) {
    //pass icn, folder path and list of control names/resource names to the loadEsrResources function
    loadEsrResources(icn, '/webresources/vhacrm_/ESRParts', 'WebResource_esrenrollment|enrollment.htm,WebResource_esreligibility|eligibility.htm,WebResource_esrdemographics|demographics.htm');
}

