function loadLOBForm() {

    var HDFORMID = "836e163c-5f4e-4abb-a75b-5e8e9c70deb4";
    var HBFORMID = "d8e13fa0-e09f-482b-ac15-d7d212ff323e";
    var ROFORMID = "73b31959-329b-4967-ab19-cf115109c91c";
    var NCCHVFORMID = "e3e6071c-c046-4deb-90ad-f9ae69a5e3b5";
	var HECFORMID = "498612d2-6cb0-450b-a285-21acec2bb22f";
	
    if (Xrm.Page.ui.getFormType() != 1) {
        var currentFormName = Xrm.Page.ui.formSelector.getCurrentItem().getLabel();
        var currentFormId = Xrm.Page.ui.formSelector.getCurrentItem().getId();

        var lob = Xrm.Page.getAttribute("vhacrm_lobid").getValue();
        var formId = ROFORMID;

        switch (lob[0].name) {
            case "Help Desk":
                if (Xrm.Page.ui.formSelector.items.get(HDFORMID) != null) {
                    formId = HDFORMID;
                }
                break;
            case "Health Benefits":
                if (Xrm.Page.ui.formSelector.items.get(HBFORMID) != null) {
                    formId = HBFORMID;
                }
                break;
            case "HRC":
                if (Xrm.Page.ui.formSelector.items.get(HBFORMID) != null) {
                    formId = HBFORMID;
                }
                break;
            case "NCCHV":
                if (Xrm.Page.ui.formSelector.items.get(NCCHVFORMID) != null) {
                    formId = NCCHVFORMID;
                }
                break;
			case "HEC":
                if (Xrm.Page.ui.formSelector.items.get(HECFORMID) != null) {
                    formId = HECFORMID;
                }
                break;
			case "EED":
                if (Xrm.Page.ui.formSelector.items.get(HECFORMID) != null) {
                    formId = HECFORMID;
                }
                break;
				
            default:
                formId = ROFORMID;
                break;
        }

        if (Xrm.Page.ui.formSelector.items.get(formId) != null && currentFormId != formId) {
            Xrm.Page.ui.formSelector.items.get(formId).navigate();
        }

    }

}

function preventAutoSave(context) {
    var eventArgs = context.getEventArgs();

    if (eventArgs.getSaveMode() == 70) {
        eventArgs.preventDefault();
    }
}

var mvi = {
    personSelected: function (id, name) {
        var veteran = new Array();
        veteran[0] = new Object();
        veteran[0].id = id;
        veteran[0].name = name;
        veteran[0].entityType = "contact";
        Xrm.Page.getAttribute("customerid").setValue(veteran);

        Xrm.Page.getAttribute("customerid").fireOnChange();
    }
}


///takes icn, path to web resources (starting from root CRM url) and list of form control names and web resource names as arguments
///example - loadEsrResources(icn, '/webresources/vhacrm_/ESRParts', 'WebResource_enrollment|enrollment.htm,WebResource_esreligibility|eligibility.htm,WebResource_demographics|demographics.htm');
function loadEsrResources(icn, resourcepath, resourceparam) {
    SDK.REST.retrieveMultipleRecords("bah_keyvaluepair",
		"$select=*&$filter=bah_name_text eq 'esr_endpoint'",
		function (data) {
		    if (data.length > 0) {
		        //figure out the full url to the BAH esr proxy
		        var esrEndpoint = data[0].bah_stringvalue_text;
		        var actualEndpoint = esrEndpoint.replace('{0}', '000000' + icn + '000000'); //pad ICN with six zeroes on beginning and end

		        //build the querystring to call the page that will query esr and display the data - note CRM requires everything be encoded and passed in a 'data' parameter
		        var qs = 'data=' + encodeURIComponent('esr=' + encodeURIComponent(actualEndpoint));

		        var resourcearr = resourceparam.split(',');

		        if (resourcearr.length > 0) {
		            for (var i = 0; i < resourcearr.length; i++) {
		                try {
		                    //start with assumption that resource name and control name are the same
		                    var controlname = "";
		                    var webresourcename = "";

		                    //check to see if we have pipe-separated value -> control name should be first, resource name should be second
		                    if (resourcearr[i].indexOf('|') > 0) {
		                        controlname = resourcearr[i].split('|')[0];
		                        webresourcename = resourcearr[i].split('|')[1];
		                    }
		                    else {
		                        throw ("ESR resource target control and resource name not supplied in correct format.")
		                    }

		                    //get a reference to the iframe
		                    var webresource = Xrm.Page.ui.controls.get(controlname);
		                    if (webresource == null) {
		                        throw ("Could not find ESR resource target control with name - '" + controlname + "'");
		                    }

		                    //set the iframe's url
		                    var webresourceUrl = Xrm.Page.context.getClientUrl() + resourcepath + '/' + webresourcename + '?' + qs;
		                    webresource.setSrc(webresourceUrl);
		                }
		                catch (err) { alert(err); }
		            }
		        }
		    }
		},
		function (error) {
		    //do nothing
		},
		function () {
		    //do nothing on completion
		}
	);
}
