# Filename: solution-extract-only.ps1
param(
  [Parameter(Mandatory=$True)]
  [string]$SolutionName
) 

$script_path = $myinvocation.mycommand.path
$script_folder = Split-Path $script_path -Parent
$project_path = Split-Path $script_folder -Parent
$solutionFilesFolder = Join-Path $project_path "source"
$log_path = Join-Path $project_path "logs"

$transcriptfile = "$log_path/solution-extract-only-transcript-$(get-date -f yyyyMMdd-HHmmss).log"
$logfile = "$log_path/solution-extract-only-sp_log$(get-date -f yyyyMMdd-HHmmss).log"

$ErrorActionPreference="SilentlyContinue"
Stop-Transcript | out-null
$ErrorActionPreference = "Stop"
Start-Transcript -path "$transcriptfile" -append

# SolutionPackager location
$solutionPackager = Join-Path $project_path "tools/solutionpackager.exe"
Write-Host "SolutionPackager: $solutionPackager"
Write-Host "Solution Files Folder: $solutionFilesFolder"

Write-Host "Removing existing source files proactively before solution unpack"
#$removeoutput = Get-ChildItem "$solutionFilesFolder" -Filter *.dll -Recurse | Remove-Item
$removeoutput = Get-ChildItem "$solutionFilesFolder" -Recurse | Where-Object{!($_.PSIsContainer)} | Remove-Item
Write-Host $removeoutput

#Solution Packager
$extractOuput = & "$solutionPackager" /action:Extract /zipfile:"$project_path\$SolutionName.zip" /folder:"$solutionFilesFolder" /errorlevel:verbose /allowWrite:Yes /allowDelete:Yes /log:$logfile /clobber
#Write-Output $extractOuput

if ($lastexitcode -ne 0)
{
    throw "Solution Extract operation failed with exit code: $lastexitcode"
}
else
{
    if (($extractOuput -ne $null) -and ($extractOuput -like "*warnings encountered*"))
    {
        Write-Warning "Solution Packager encountered warnings. Check the output."
        #Write-Log "Solution Packager encountered warnings. Check the output."
    }
}

Stop-Transcript
# End of script