
package gov.va.med.cds.testharness.vhim400.builders;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.logging.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SensitivePatientDataAccessBuilder extends AbstractEntryPointBuilder {
	private static int PATIENT_ACCESS_IDX = 10000;

	public SensitivePatientDataAccessBuilder() {
		super();
	}

	public SensitivePatientDataAccessBuilder(Random aRandom) {
		super(aRandom);
	}

	public Element makeInsertPatientData() {
		return makePatientData();
	}

	public List<Element> makeInsertPatientData(int count) {
		return makePatientData(count);
	}

	public Element makePatientData() {
		return null;
	}

	public Element makePatientData(MultiValueMap map, String facilityId, String menuOption) {
		Element PatientData = createPatientData(PATIENT_ACCESS_IDX++, map, facilityId, menuOption);

		return PatientData;
	}

	public Element makePatientData(MultiValueMap map, String facilityId1, String facilityId2, String menuOption) {
		Element PatientData = createPatientData(PATIENT_ACCESS_IDX++, map, facilityId1, facilityId2, menuOption);

		return PatientData;
	}

	public Element createEntryPointRecord(Element personIdentifier) {
		return null;
	}

	public List<Element> makePatientData(int number) {
		return null;
	}

	/*
	 * public List<Element> makePatientData(int number, Element
	 * personIdentifier, String duz, String menuOption) { List<Element>
	 * patientDataRecordsList = new ArrayList<Element>(number); for (int i = 0;
	 * i < number; i++) {
	 * patientDataRecordsList.add(makePatientData(personIdentifier, duz,
	 * menuOption)); }
	 * 
	 * return patientDataRecordsList; }
	 */

	private Element createPatientData(int id, MultiValueMap pidsOtherValuesMap, String facilityId, String menuOption) {

		Element sensitivePatientDataAccessEvents = DocumentHelper.createElement("patientDataAccessedEvents");

		List list;
		Set entrySet = pidsOtherValuesMap.entrySet();
		Iterator it = entrySet.iterator();

		while (it.hasNext()) {
			Map.Entry mapEntry = (Map.Entry) it.next();
			list = (List) pidsOtherValuesMap.get(mapEntry.getKey());
			for (int j = 0; j < list.size(); j++) {

				Element patientDataAccessedEvent = DocumentHelper.createElement("patientDataAccessedEvent");
				Element newPatient = createPatientIdLite("patient");

				newPatient.element("identifier").element("identity").setText((String) mapEntry.getKey());
				newPatient.element("identifier").element("assigningFacility").setText(facilityId);
				newPatient.element("identifier").element("assigningAuthority").setText("USVHA");

				patientDataAccessedEvent.add(newPatient);

				Element element1 = DocumentHelper.createElement("DUZ");
				element1.setText((String) list.get(j));
				patientDataAccessedEvent.add(element1);

				Element element2 = DocumentHelper.createElement("menuOption");
				element2.setText(menuOption);
				patientDataAccessedEvent.add(element2);

				sensitivePatientDataAccessEvents.add(patientDataAccessedEvent);
			}
		}

		return sensitivePatientDataAccessEvents;
	}

	private Element createPatientData(int id, MultiValueMap pidsOtherValuesMap, String facilityId1, String facilityId2,
			String menuOption) {

		Element sensitivePatientDataAccessEvents = DocumentHelper.createElement("patientDataAccessedEvents");

		Iterator<String> it = pidsOtherValuesMap.keySet().iterator();

		while (it.hasNext()) {
			String theKey = it.next();
			String value = (String) ((ArrayList) pidsOtherValuesMap.get(theKey)).get(0);
			Element patientDataAccessedEvent = DocumentHelper.createElement("patientDataAccessedEvent");

			Element newPatient = createPatientIdLite("patient");

			newPatient.element("identifier").element("identity").setText(theKey);
			newPatient.element("identifier").element("assigningFacility").setText(facilityId1);
			newPatient.element("identifier").element("assigningAuthority").setText("USVHA");

			patientDataAccessedEvent.add(newPatient);

			Element element1 = DocumentHelper.createElement("DUZ");
			element1.setText(value);
			patientDataAccessedEvent.add(element1);

			Element element2 = DocumentHelper.createElement("menuOption");
			element2.setText(menuOption);
			patientDataAccessedEvent.add(element2);

			sensitivePatientDataAccessEvents.add(patientDataAccessedEvent);
		}

		it = pidsOtherValuesMap.keySet().iterator();
		while (it.hasNext()) {
			String theKey = it.next();
			String value = (String) ((ArrayList) pidsOtherValuesMap.get(theKey)).get(0);
			Element patientDataAccessedEvent = DocumentHelper.createElement("patientDataAccessedEvent");

			Element newPatient = createPatientIdLite("patient");

			newPatient.element("identifier").element("identity").setText(theKey);
			newPatient.element("identifier").element("assigningFacility").setText(facilityId2);
			newPatient.element("identifier").element("assigningAuthority").setText("USVHA");

			patientDataAccessedEvent.add(newPatient);

			Element element1 = DocumentHelper.createElement("DUZ");
			element1.setText(value);
			patientDataAccessedEvent.add(element1);

			Element element2 = DocumentHelper.createElement("menuOption");
			element2.setText(menuOption);
			patientDataAccessedEvent.add(element2);

			sensitivePatientDataAccessEvents.add(patientDataAccessedEvent);
		}

		return sensitivePatientDataAccessEvents;
	}

	@SuppressWarnings("unchecked")
	private void setSensitivePatientDataAccessValues(Element sensitivePatientDataAccessEvents, int id, String dfn,
			String duz, String facilityId, String menuOption) {

		Element newPatient = createPatientIdLite("patient");
		// if (dfn != null) {
		newPatient.element("identifier").element("identity").setText(dfn);
		newPatient.element("identifier").element("assigningFacility").setText(facilityId);
		newPatient.element("identifier").element("assigningAuthority").setText("USVHA");
		// }

		sensitivePatientDataAccessEvents.element("patientDataAccessedEvent").add(newPatient);

		Element element = DocumentHelper.createElement("DUZ");
		element.setText(duz);
		sensitivePatientDataAccessEvents.element("patientDataAccessedEvent").add(element);

		element = DocumentHelper.createElement("menuOption");
		element.setText(menuOption);
		sensitivePatientDataAccessEvents.element("patientDataAccessedEvent").add(element);

	}

	public void printPatientData(List<Element> listOfResults) {
		printDomainRecords(listOfResults);
	}

	public void printPatientData(List<Element> listOfResults, Logger logger) {
		printDomainRecords(listOfResults, logger);
	}

	protected void printPatientData(Element sensitivePatientDataAccess) {
		printDomainRecord(sensitivePatientDataAccess);
	}

	protected void printPatientData(Element sensitivePatientDataAccess, Logger logger) {
		printDomainRecord(sensitivePatientDataAccess, logger);
	}

	public String fillPrintBuffer(Object obj) {
		String returnString = "";

		if ((obj != null) && (obj instanceof Element)) {
			returnString = ((Element) obj).asXML();
		}

		return returnString;
	}

}
