

package gov.va.med.cds.testharness.vhim400.builders;


import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.List;


//wrapper for VdmIntoleranceConditionBuilder
public class IntoleranceConditionBuilderFactory
    implements
        ClinicalDomainBuilderFactoryInterface
{
    private IntoleranceConditionBuilder intoleranceConditionBuilder = new IntoleranceConditionBuilder();


    public void createClinicalDomainData( Document clinicalData, int cnt, Element patientIdentifer )
    {
        // call the appropriate builder and set the clinicaldata.patient.domain with it
        buildIntoleranceConditionData( clinicalData, cnt, patientIdentifer );
    }


    public void createClinicalDomainData( Document clinicalData, String recordIdentifier )
    {
        // call the appropriate builder and set the clinicaldata.patient.domain with it
        buildIntoleranceConditionData( clinicalData, recordIdentifier );
    }


    public void createClinicalDomainData( Document clinicalData, String recordIdentifier, String recordVersion )
    {
        buildIntoleranceConditionData( clinicalData, recordIdentifier, recordVersion );
    }


    private void buildIntoleranceConditionData( Document clinicalData, String recordIdentifier )
    {

        Element rootElement = clinicalData.getRootElement();
        Element patient = rootElement.element( "patient" );
        Element intoleranceCondition = intoleranceConditionBuilder.makeIntoleranceCondition( "intoleranceConditions", recordIdentifier );
        patient.add( intoleranceCondition );

    }


    private void buildIntoleranceConditionData( Document clinicalData, String recordIdentifier, String recordVersion )
    {

        Element rootElement = clinicalData.getRootElement();
        Element patient = rootElement.element( "patient" );
        Element intoleranceCondition = intoleranceConditionBuilder
                        .makeIntoleranceCondition( "intoleranceConditions", recordIdentifier, recordVersion );
        patient.add( intoleranceCondition );

    }


    private void buildIntoleranceConditionData( Document clinicalData, int count, Element patientIdentifer )
    {
        Element rootElement = clinicalData.getRootElement();

        Element patient = rootElement.element( "patient" );
        
        Element templateId = rootElement.element( "templateId" );
        if ( templateId.getText().equals( "IntoleranceConditionCreateOrUpdate40060" ) )
        {
            Element requestedNationalId = DocumentHelper.createElement( "requestedNationalId" );
            requestedNationalId.addText("1111111111");
            patient.add( requestedNationalId );
        }
        List<Element> intoleranceConditions = intoleranceConditionBuilder.makeAllergies( count, patientIdentifer );

        for ( Element intoleranceCondition : intoleranceConditions )
        {
            patient.add( intoleranceCondition );
        }
    }


    public void setIntoleranceConditionBuilder( IntoleranceConditionBuilder intoleranceConditionBuilder )
    {
        this.intoleranceConditionBuilder = intoleranceConditionBuilder;
    }
}
