/**
 * 
 */
package gov.va.med.cds.testharness.vhim400.builders;

import java.util.List;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/**
 * @author vhaislegberb
 *
 */
public class DBQQuestionnaireResultBuilderFactory
    implements
        ClinicalDomainBuilderFactoryInterface
{
    
    private DBQQuestionnaireResultBuilder builder;

    
    /* (non-Javadoc)
     * @see gov.va.med.cds.testharness.vhim400.builders.ClinicalDomainBuilderFactoryInterface#createClinicalDomainData(org.dom4j.Document, int, org.dom4j.Element)
     */
    @Override
    public void createClinicalDomainData( Document clinicalData, int count, Element patientIdentifier )
    {
        Element rootElement = clinicalData.getRootElement();

        Element patient = rootElement.element( "patient" );

        Element questionnaireResultsElement = DocumentHelper.createElement("questionnaireResults");
        patient.add(questionnaireResultsElement);
        
        List<Element> questionnaireResults = builder.makeQuestionnaireResults( count, patientIdentifier );
        
        for ( Element questionnaireResult : questionnaireResults )
        {
            questionnaireResultsElement.add( questionnaireResult );
        }

    }
    
    /**
     * Sets the build class used by the builder factory.
     * @param builder
     */
    public void setBuilder( DBQQuestionnaireResultBuilder builder )
    {
        this.builder = builder;
    }

}
