

package gov.va.med.cds.testharness.examples;


import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.util.StreamUtil;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

import java.io.IOException;


/**
 * Demonstrates how to use the Spring resource loader
 *
 */
@RunWith( SuiteAwareRunner.class )
public class ResourceLoaderTest
{
    private static ResourceLoader loader;


    @BeforeClass
    @Suite( groups = "checkintest" )
    public static void beforeResourceLoaderTestClassSetUp( )
    {
        loader = new DefaultResourceLoader();
    }


    @AfterClass
    @Suite( groups = "checkintest" )
    public static void afterResourceLoaderTestClassTearDown( )
    {
        loader = null;
    }


    /**
     * Demonstrates loading a file from classpath
     * @throws IOException
     */
    @Test
    @Suite( groups = "checkintest" )
    public void testClassPathResourceLoad( )
        throws IOException
    {
        Resource resource = loader.getResource( "classpath:gov/va/med/cds/testharness/examples/ResourceLoaderTest_TestFile.xml" );
        Assert.assertNotNull( "the class path resource should have been found", resource );
        String content = StreamUtil.streamToString( resource.getInputStream() );
        Assert.assertEquals( content, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" );
    }
}
